% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{find_overlapping_coordinates}
\alias{find_overlapping_coordinates}
\title{Find peaks that overlap a specific genomic location}
\usage{
find_overlapping_coordinates(coord_list, coord, maxgap = 0)
}
\arguments{
\item{coord_list}{A list of coordinates to be searched for overlap in the
form chr_100_2000.}

\item{coord}{The coordinates that you want to find in the form chr1_100_2000.}

\item{maxgap}{The maximum distance in base pairs between coord and the
coord_list that should count as overlapping. Default is 0.}
}
\value{
A character vector of the peaks that overlap coord.
}
\description{
Find peaks that overlap a specific genomic location
}
\examples{
  test_coords <- c("chr18_10025_10225", "chr18_10603_11103",
                   "chr18_11604_13986",
                   "chr18_157883_158536", "chr18_217477_218555",
                   "chr18_245734_246234")
  find_overlapping_coordinates(test_coords, "chr18:10,100-1246234")


}
