% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/background_peaks.R
\name{getPermutedData}
\alias{getPermutedData}
\title{getPermutedData}
\usage{
getPermutedData(object, niterations = 10, w = 0.1, bs = 50)
}
\arguments{
\item{object}{SummarizedExperiment}

\item{niterations}{number of background peaks to sample}

\item{w}{parameter controlling similarity of background peaks}

\item{bs}{bin size parameter}
}
\value{
new SummarizedExperiment with addition assays representing permuted
version of counts
}
\description{
Function to get permuted data while maintaining biases
}
\details{
Replaces the counts at a given peak with the count from another peak
with similar GC content and average accessibility
}
\examples{

# Load very small example counts (already filtered)
data(mini_counts, package = "chromVAR")

# get background peaks
perm_counts <- getPermutedData(mini_counts, niterations = 2)

}
