% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup.R
\name{setup_mappa}
\alias{setup_mappa}
\title{Function to setup mappability}
\usage{
setup_mappa(mappa_code, genome, ldef_code, ldef_obj)
}
\arguments{
\item{mappa_code}{One of \code{NULL}, a file path to a custom mappability file,
or an \code{integer} for a valid read length given by \code{supported_read_lengths}.
If a file, it should contain a header with two column named 'gene_id' and 'mappa'.
Gene IDs should be Entrez IDs, and mappability values should range from 0 and 1.
Default value is NULL.}

\item{genome}{One of the \code{supported_genomes()}.}

\item{ldef_code}{One of 'nearest_tss', 'nearest_gene', 'exon', 'intron', '1kb',
'1kb_outside', '1kb_outside_upstream', '5kb', '5kb_outside', '5kb_outside_upstream',
'10kb', '10kb_outside', '10kb_outside_upstream'. Alternately, a file path for
a custom locus definition. NOTE: Must be for a \code{supported_genome()}, and
must have columns 'chr', 'start', 'end', and 'gene_id', or 'geneid'.}

\item{ldef_obj}{A \code{LocusDefinition} object.}
}
\value{
A \code{data.frame} with columns \code{gene_id} and \code{mappa}.
}
\description{
Function to setup mappability
}
