% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_polyenrich_spline.R
\name{plot_polyenrich_spline}
\alias{plot_polyenrich_spline}
\title{QC plot for Poly-Enrich}
\usage{
plot_polyenrich_spline(
  peaks,
  locusdef = "nearest_tss",
  genome = supported_genomes(),
  mappability = NULL,
  legend = TRUE,
  xlim = NULL,
  ylim = NULL
)
}
\arguments{
\item{peaks}{Either a file path or a \code{data.frame} of peaks in BED-like
format. If a file path, the following formats are fully supported via their
file extensions: .bed, .broadPeak, .narrowPeak, .gff3, .gff2, .gff, and .bedGraph
or .bdg. BED3 through BED6 files are supported under the .bed extension. Files
without these extensions are supported under the conditions that the first 3
columns correspond to 'chr', 'start', and 'end' and that there is either no
header column, or it is commented out. If a \code{data.frame} A BEDX+Y style
\code{data.frame}. See \code{GenomicRanges::makeGRangesFromDataFrame} for
acceptable column names.}

\item{locusdef}{One of: 'nearest_tss', 'nearest_gene', 'exon', 'intron', '1kb',
'1kb_outside', '1kb_outside_upstream', '5kb', '5kb_outside', '5kb_outside_upstream',
'10kb', '10kb_outside', '10kb_outside_upstream'. For a description of each,
see the vignette or \code{\link{supported_locusdefs}}. Alternately, a file path for
a custom locus definition. NOTE: Must be for a \code{supported_genome()}, and
must have columns 'chr', 'start', 'end', and 'gene_id' or 'geneid'. For an
example custom locus definition file, see the vignette.}

\item{genome}{One of the \code{supported_genomes()}.}

\item{mappability}{One of \code{NULL}, a file path to a custom mappability file,
or an \code{integer} for a valid read length given by \code{supported_read_lengths}.
If a file, it should contain a header with two column named 'gene_id' and 'mappa'.
Gene IDs should be Entrez IDs, and mappability values should range from 0 and 1.
For an example custom mappability file, see the vignette. Default value is NULL.}

\item{legend}{If true, a legend will be drawn on the plot.}

\item{xlim}{Set the x-axis limit. NULL means select x-lim automatically.}

\item{ylim}{Set the y-axis limit. NULL means select y-lim automatically.}
}
\value{
A trellis plot object.
}
\description{
Create a plot the relationship between number of peaks assigned to a gene and
locus length. The plot shows an empirical fit to the data using a binomial
smoothing spline.
}
\examples{

# Spline plot for E2F4 example peak dataset.
data(peaks_E2F4, package = 'chipenrich.data')

# Create the plot for a different locus definition
# to compare the effect.
plot_polyenrich_spline(peaks_E2F4, locusdef = 'nearest_gene', genome = 'hg19')

}
