% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{load_peaks}
\alias{load_peaks}
\title{Convert a BEDX+Y data.frame and into GRanges}
\usage{
load_peaks(dframe, keep.extra.columns = TRUE)
}
\arguments{
\item{dframe}{A BEDX+Y style \code{data.frame}. See \code{GenomicRanges::makeGRangesFromDataFrame}
for acceptable column names for appropriate conversion to \code{GRanges}.}

\item{keep.extra.columns}{Keep extra columns parameter from \code{GenomicRanges::makeGRangesFromDataFrame()}.}
}
\value{
A \code{GRanges} that may or may not \code{keep.extra.columns}, and
that may or may not be stranded, depending on whether there is strand column
in the \code{dframe}.
}
\description{
Given a \code{data.frame} in BEDX+Y format, use the built-in function
\code{GenomicRanges::makeGRangesFromDataFrame()} to convert to \code{GRanges}.
}
\details{
Typically, this function will not be used alone, but inside \code{chipenrich()}.
}
\examples{

# Example with just chr, start, end
peaks_df = data.frame(
chr = c('chr1','chr2','chr3'),
start = c(35,74,235),
end = c(46,83,421),
stringsAsFactors = FALSE)
peaks = load_peaks(peaks_df)

# Example with extra columns
peaks_df = data.frame(
chr = c('chr1','chr2','chr3'),
start = c(35,74,235),
end = c(46,83,421),
strand = c('+','-','+'),
score = c(36, 747, 13),
stringsAsFactors = FALSE)
peaks = load_peaks(peaks_df, keep.extra.columns = TRUE)

}
