% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_ericscript.R
\name{import_ericscript}
\alias{import_ericscript}
\title{Import results from a EricScript run into a list of Fusion objects.}
\usage{
import_ericscript(filename, genome_version, limit)
}
\arguments{
\item{filename}{Filename for the EricScript results file.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from a EricScript run into a list of
Fusion objects.
}
\examples{
ericscriptData <- system.file(
  "extdata",
  "ericscript_SRR1657556.results.total.tsv",
  package = "chimeraviz")
fusions <- import_ericscript(ericscriptData, "hg19", 3)
# This should import a list of 3 fusions described in Fusion objects.

}
