% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_aeron.R
\name{import_aeron}
\alias{import_aeron}
\title{Import results from an Aeron run into a list of Fusion objects.}
\usage{
import_aeron(
  filename_fusion_support,
  filename_fusion_transcript,
  genome_version,
  limit
)
}
\arguments{
\item{filename_fusion_support}{Filename for the Aeron result file
fusion_support..txt.}

\item{filename_fusion_transcript}{Filename for the Aeron result file
fusion_transcripts..txt.}

\item{genome_version}{Which genome was used in mapping (hg19, hg38, etc.).}

\item{limit}{A limit on how many lines to read.}
}
\value{
A list of Fusion objects.
}
\description{
A function that imports the results from an Aeron run into a list of Fusion
objects.
}
\details{
Note that the strands and breakpoint positions are not included in the
result files from Aeron. These have to be retrieved manually, using the
ensembl identifiers (which are included in the result files, and will be
available in the Fusion objects after importing).
}
\examples{
aeronfusionsupportfile <- system.file(
  "extdata",
  "aeron_fusion_support.txt",
  package="chimeraviz")
aeronfusiontranscriptfile <- system.file(
  "extdata",
  "aeron_fusion_transcripts.fa",
  package="chimeraviz")
fusions <- import_aeron(
  aeronfusionsupportfile,
  aeronfusiontranscriptfile,
  "hg19",
  3)
# This should import a list of 3 fusions described in Fusion objects.
}
