% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reports.R
\name{create_fusion_report}
\alias{create_fusion_report}
\title{Create a Fusion Report}
\usage{
create_fusion_report(fusions, output_filename, quiet = TRUE)
}
\arguments{
\item{fusions}{A list of Fusion objects.}

\item{output_filename}{Output html-file filename.}

\item{quiet}{Parameter passed to rmarkdown::render() to toggle its output.}
}
\value{
Creates a html report with an overplot and a sortable, searchable
table with the fusion data.
}
\description{
This function will create a html report with an overplot and a sortable,
searchable table with the fusion data.
}
\examples{
# Load data
defuse833ke <- system.file(
  "extdata",
  "defuse_833ke_results.filtered.tsv",
  package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 3)
# Temporary file to store the report
random_filename <- paste0(
  paste0(sample(LETTERS, 5, replace = TRUE), collapse=''),
  ".png"
)
# Create report
create_fusion_report(fusions, random_filename)
# Delete the file
file.remove(random_filename)

}
