% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_circle.R
\name{chimeraviz-internals-fusions_to_gene_label_data}
\alias{chimeraviz-internals-fusions_to_gene_label_data}
\alias{.fusions_to_gene_label_data}
\title{Create gene label data for RCircos from the given fusions.}
\usage{
.fusions_to_gene_label_data(fusion_list)
}
\arguments{
\item{fusion_list}{A list of Fusion objects.}
}
\value{
A data frame with fusion gene label data compatible with RCircos.Gene.Name.Plot()

# @examples # Apparently examples shouldn't be set on private functions
defuse833ke <- system.file("extdata", "defuse_833ke_results.filtered.tsv", package="chimeraviz")
fusions <- import_defuse(defuse833ke, "hg19", 3)
labelData <- chimeraviz::.fusions_to_gene_label_data(fusions)
# This labelData can be used with RCircos.Gene.Connector.Plot() and RCircos.Gene.Name.Plot()
}
\description{
This function takes a list of Fusion objects and creates a data frame in the
format that RCircos.Gene.Name.Plot() expects for gene label data.
}
