% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotAllToOne.R
\name{plotAllToOne}
\alias{plotAllToOne}
\title{Plot the raw fragment size metrics (e.g. proportion, cdf and 1-cdf) of
all groups with different colors in a single plot}
\usage{
plotAllToOne(x, order, plot, vline, xlim, ylim, ...)
}
\arguments{
\item{x}{A long-format dataframe contains the metrics of different cohort.}

\item{order}{The groups show in the final plot,
the input value should be vector,
e.g. `groups=c('group1','group2')`,
default is all folders in the folder path.}

\item{plot}{The plot type, default is 'all' which means
all of proportion, cdf and 1-cdf plots will be shown.}

\item{vline}{Vertical dashed lines, default value is `c(81,167)`.}

\item{xlim}{The x axis range shown in the plot. Default is `c(0,500)`.}

\item{ylim}{The y axis range shown in the fraction of fragment size plots.
Default is `c(0,0.035)`.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns a list plots.
}
\description{
Plot the raw fragment size metrics (e.g. proportion, cdf and 1-cdf) of
all groups with different colors in a single plot
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the sizes.
df <- callSize(path = path)
# Plot all samples from multiple groups into one figure.
plot <- plotAllToOne(df)
}
\author{
Haichao Wang
}
