% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callPeakDistance.R
\name{callPeakDistance}
\alias{callPeakDistance}
\title{Calculate the inter-peak distance of insert size}
\usage{
callPeakDistance(
  path = getwd(),
  groups,
  limit,
  outfmt,
  summary,
  mincount,
  input_type,
  ...
)
}
\arguments{
\item{path}{The root folder containing all groups folders.
Default is the present working folder.}

\item{groups}{The name of the groups, the input value should be vector,
e.g. groups=c('group1','group2').
Default is all folders in the folder path.}

\item{limit}{The insert size range that will be focused on.
Default value is `limit = c(35,135)`.}

\item{outfmt}{The output format, a 'list' or 'dataframe'.
Default is dataframe.}

\item{summary}{If TRUE, summarize the output.}

\item{mincount}{The minimum count value of inter-peak distance
in the summary.}

\item{input_type}{Character. The input file format,
should be one of these: 'picard', 'bam', 'cfdnapro'. 
The bam files has to be marked duplicates.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The function returns the inter peak distance in list
  or dataframe format.
}
\description{
Calculate the inter-peak distance of insert size
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the inter-peak distance.
df <- callPeakDistance(path = path)
}
\author{
Haichao Wang
}
