% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calMetrics.R
\name{callMetrics}
\alias{callMetrics}
\title{Calculate the metrics of insert size}
\usage{
callMetrics(
  path = getwd(),
  groups,
  fun = "all",
  outfmt = "df",
  input_type,
  ...
)
}
\arguments{
\item{path}{The root folder containing all groups folders,
default is the present working folder.}

\item{groups}{The name of the groups, the input value should be vector,
e.g. groups=c('group1','group2'),
default is all sub-folders in the 'path'.}

\item{fun}{String value, the types of metrics to be calculated.
Default is 'all', which means both median and mean values
will be returned.}

\item{outfmt}{The output format, a 'list' or 'dataframe' or 'df',
default is dataframe.}

\item{input_type}{Character. The input file format,
should be one of these: 'picard', 'bam' or 'cfdnapro'. 
The bam files has to be marked duplicates.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
The inter valley distance in list or dataframe format.
}
\description{
Calculate the metrics of insert size
}
\examples{
# Get the path to example data.
path <- examplePath("groups_picard")
# Calculate the metrics.
df <- callMetrics(path = path)
}
\author{
Haichao Wang
}
