% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{getDiRatio}
\alias{getDiRatio}
\title{Getting the Directionality Table}
\usage{
getDiRatio(object)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}
}
\value{
A data frame. It contains nine rows: "Cell Number",
"Directionality Ratio","Mean Cumulative Directionality Ratio",
"Stable Directionality Ratio", "Number of returns","Min CumDR",
"Location of Min CumDR, Steps with less CumDR than DR",
"Directional Persistence".
}
\description{
Directionality Ratio is the displacement divided by
the
total length of the total path distance, where displacement is the
straight line length between the start point and the endpoint of
the migration trajectory,
}
\details{
Directionality Ratio and Directional persistence
}
\examples{
rmTD <- get(data(preProcCellMig))
rmTD <- DiRatio(rmTD, export=FALSE)
head(getDiRatio(rmTD))

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
