% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{cntrd}
\alias{cntrd}
\title{Calculates Centroids}
\usage{
cntrd(im, mx, sz, interactive = NULL)
}
\arguments{
\item{im}{numeric matrix corresponding to the image to process}

\item{mx}{location of local maxima to pixel-levels accuracy}

\item{sz}{diameter of the window over which to average to calculate
the centroid. should be big enough.}

\item{interactive}{numeric; if set to 1 (or any positive number),
an image showing the
computed centroids will be visualized}
}
\value{
a data.frame with 4 columns, containing, x, y, brightness,
and
the square of the radius of gyration for each cell.
}
\description{
Calculates the centroid of bright spots to sub-pixel accuracy.
Inspired by Grier &
Crocker's feature for IDL, but greatly simplified and optimized for
MATLAB, and then
further ported to R.
CREATED: Eric R. Dufresne, Yale University, Feb 4 2005.
}
\examples{
x0 <- getCellImages(get(data(TrackCellsDataset)))
x0 <- x0$images[[1]][seq(80,150,by=1), seq(80,150,by=1)]
b <- cellmigRation:::bpass(image_array = x0, lnoise = 2,
                           lobject = 15, threshold = 1)
pk <- cellmigRation:::pkfnd(b, th = 2, sz = 5)
cnt <- cellmigRation:::cntrd(im = b, mx = pk, sz = 5)
cnt

}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
\url{https://www.mathworks.com/matlabcentral/fileexchange/60349-fasttracks}
}
\author{
Damiano Fantini, \email{damiano.fantini@gmail.com}
}
\keyword{internal}
