% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions_v8.R
\name{CellMigPCAclustALL}
\alias{CellMigPCAclustALL}
\title{PCA Clusters of different conditions}
\usage{
CellMigPCAclustALL(
  object,
  ExpName = "PCA_Clusters",
  parameters = c(1, 2, 3),
  export = FALSE,
  interactive = TRUE
)
}
\arguments{
\item{object}{\code{CellMig} class object, which is a list of data
frames resulted from the PreProcessing.}

\item{ExpName}{A character string. The ExpName will be appended
to all exported tracks and statistics data.}

\item{parameters}{A numeric vector contains the parameters to be
included in the Principal Component Analysis. These numbers can be
obtained from the outcome of the FinRes() function.}

\item{export}{if `TRUE` (default), exports function output to CSV
file}

\item{interactive}{logical, shall the PCA analysis be generated in
a interactive fashion}
}
\value{
PCA Graph of cells and PCA Graph of variables.
}
\description{
The CellMigPCAclust function automatically generates
clusters based on the Principal Component Analysis.
}
\examples{
## The analysis only supports the interactive method!
## If interactive=FALSE, the function will return NULL
data(WSADataset)
wasDF1 <- WSADataset[seq(1,300,by=1), ]
wsaTD1 <- CellMig(wasDF1)
wsaTD1 <- wsaPreProcessing(wsaTD1,FrameN=55)
wsaTD1 <-FMI(wsaTD1,TimeInterval=10)
wsaTD1 <-FinRes(wsaTD1,ParCor=FALSE, export=FALSE)
wasDF2 <- WSADataset[seq(500,700,by=1), ]
wsaTD2 <- CellMig(wasDF2)
wsaTD2 <- wsaPreProcessing(wsaTD2,FrameN=55)
wsaTD2 <-FMI(wsaTD2, TimeInterval=10)
wsaTD2 <-FinRes(wsaTD2, ParCor=FALSE, export=FALSE)
AGG <- aggregateFR(wsaTD1, wsaTD2, export=FALSE)
CellMigPCAclustALL(AGG,ExpName="Aggregated_Conditions",
                   parameters=c(1,6), export=FALSE, interactive=FALSE)
# The previous line returns NULL
# In an interactive session, try running the following command (uncomment!)
# CellMigPCAclustALL(AGG,ExpName="Aggregated_Conditions",
#                    parameters=c(1,6), export=FALSE)


}
\references{
\url{https://www.data-pulse.com/dev_site/cellmigration/}
}
\author{
Salim Ghannoum \email{salim.ghannoum@medisin.uio.no}
}
