% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perplexity.R
\name{plotGridSearchPerplexity}
\alias{plotGridSearchPerplexity}
\alias{plotGridSearchPerplexity,SingleCellExperiment-method}
\alias{plotGridSearchPerplexity,celdaList-method}
\title{Visualize perplexity of a list of celda models}
\usage{
plotGridSearchPerplexity(x, altExpName = "featureSubset", sep = 5, alpha = 0.5)

\S4method{plotGridSearchPerplexity}{SingleCellExperiment}(x, altExpName = "featureSubset", sep = 5, alpha = 0.5)

\S4method{plotGridSearchPerplexity}{celdaList}(x, sep = 5, alpha = 0.5)
}
\arguments{
\item{x}{Can be one of
\itemize{
 \item A \linkS4class{SingleCellExperiment} object returned from
 \code{celdaGridSearch}, \code{recursiveSplitModule},
 or \code{recursiveSplitCell}. Must contain a list named
 \code{"celda_grid_search"} in \code{metadata(x)}.
 \item celdaList object.}}

\item{altExpName}{The name for the \link{altExp} slot
to use. Default "featureSubset". Only works if \code{x} is a
\linkS4class{SingleCellExperiment} object.}

\item{sep}{Numeric. Breaks in the x axis of the resulting plot.}

\item{alpha}{Numeric. Passed to \link{geom_jitter}. Opacity of the points.
Values of alpha range from 0 to 1, with lower values corresponding
to more transparent colors.}
}
\value{
A ggplot plot object showing perplexity as a function of clustering
 parameters.
}
\description{
Visualize perplexity of every model in a celdaList, by unique
 K/L combinations
}
\examples{
data(sceCeldaCGGridSearch)
sce <- resamplePerplexity(sceCeldaCGGridSearch)
plotGridSearchPerplexity(sce)
data(celdaCGSim, celdaCGGridSearchRes)
## Run various combinations of parameters with 'celdaGridSearch'
celdaCGGridSearchRes <- resamplePerplexity(
  celdaCGSim$counts,
  celdaCGGridSearchRes)
plotGridSearchPerplexity(celdaCGGridSearchRes)
}
