% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{subset_se_cells_for_group_test}
\alias{subset_se_cells_for_group_test}
\title{subset_se_cells_for_group_test}
\usage{
subset_se_cells_for_group_test(dataset_se, the_group, n.group = Inf,
  n.other = n.group * 5)
}
\arguments{
\item{dataset_se}{Summarised experiment object containing count data. Also
requires 'ID' and 'group' to be set within the cell information.}

\item{the_group}{The group being subsetted for}

\item{n.group}{How many cells to keep for each group. Default = Inf}

\item{n.other}{How many cells to keep from everything not in the group.
Default = \bold{n.group} * 5}
}
\value{
\emph{dataset_se} A hopefully more managably subsetted version of
the inputted \bold{dataset_se}
}
\description{
This function for use by \code{\link{contrast_each_group_to_the_rest}} 
downsamples cells from a summarizedExperiment 
(\emph{dataset_se}) - keeping \bold{n.group} (or all if fewer) 
cells from the specified group, and \bold{n.other} from the rest. 
This maintains the proportions of cells in the 'other' part of the 
differential expression comparisons.
}
\details{
Cells are randomly sampled, so set the random seed (with \emph{set.seed()})
for consistant results across runs.
}
\seealso{
Calling function \code{\link{contrast_each_group_to_the_rest}}

\code{\link{subset_cells_by_group}} Exported function for 
subsetting each group independantly upfront. 
(For when this approach is still unmanageable)
}
