% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{get_the_up_genes_for_group}
\alias{get_the_up_genes_for_group}
\title{get_the_up_genes_for_group}
\usage{
get_the_up_genes_for_group(the_group, de_table.test, de_table.ref,
  rankmetric = "TOP100_LOWER_CI_GTE1", n = 100)
}
\arguments{
\item{the_group}{The group (from the test/query experiment) to examine.}

\item{de_table.test}{A differential expression table of the query 
experiment, as generated from 
\code{\link{contrast_each_group_to_the_rest}}}

\item{de_table.ref}{A differential expression table of the reference 
dataset, as generated from 
\code{\link{contrast_each_group_to_the_rest}}}

\item{rankmetric}{Specifiy ranking method used to pick the
'top' genes. The default 'TOP100_LOWER_CI_GTE1' picks genes from the top 100
overrepresented genes (ranked by inner 95% confidence interval) - appears to 
work best for distinct cell types (e.g. tissue sample.). 'TOP100_SIG' again 
picks from the top 100 ranked genes, but requires only statistical 
significance, 95% CI threshold - may perform better on more similar cell 
clusters (e.g. PBMCs).}

\item{n}{For tweaking maximum returned genes from different ranking methods.
Will change the p-values! Suggest leaving as default unless you're keen.}
}
\value{
\emph{de_table.marked} This will be a subset of 
\bold{de_table.ref}, with an added column \emph{test_group} set to 
\bold{the_group}. If nothing passes the rankmetric criteria, NA.
}
\description{
For the most overrepresented genes of the specified group in the test 
dataset, get their rankings in all the groups of the reference dataset.
}
\details{
This is effectively a subset of the reference data, 'marked' with the 'top'
genes that represent the group of interest in the query data. The 
distribution of the \emph{rescaled ranks} of these marked genes in each 
reference data group indicate how similar they are to the query group.
}
\examples{
de_table.marked.Group3vsRef <- get_the_up_genes_for_group(
                                  the_group="Group3",
                                  de_table.test=de_table.demo_query, 
                                  de_table.ref=de_table.demo_ref)

}
\seealso{
\code{\link{contrast_each_group_to_the_rest}} For prepraring the 
de_table.* tables.
\code{\link{get_the_up_genes_for_all_possible_groups}} For running 
all query groups at once.
}
