% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_labelling_functions.r
\name{get_rankstat_table}
\alias{get_rankstat_table}
\title{get_rankstat_table}
\usage{
get_rankstat_table(de_table.ref.marked, the_test_group)
}
\arguments{
\item{de_table.ref.marked}{The output of 
\code{\link{get_the_up_genes_for_all_possible_groups}} for the contrast 
of interest.}

\item{the_test_group}{Name of query group to test}
}
\value{
A tibble of query group name (test_group), 
number of 'top' genes (n), 
reference dataset group (group) with its ranking (grouprank) and the median 
(rescaled 0..1) ranking of 'top' genes (median_rank).
}
\description{
Summarise the comparison of the specified query group against in the 
comparison in \bold{de_table.ref.marked} - number of 'top' genes and their 
median rank in each of the reference groups, with reference group rankings.
}
\examples{

# Make input
# de_table.demo_query <- contrast_each_group_to_the_rest(demo_query_se, "demo_query")
# de_table.demo_ref   <- contrast_each_group_to_the_rest(demo_ref_se,   "demo_ref")

de_table.marked.query_vs_ref <- get_the_up_genes_for_all_possible_groups(
    de_table.demo_query, 
    de_table.demo_ref)

get_rankstat_table(de_table.marked.query_vs_ref, "Group3")

}
\seealso{
\code{\link{get_the_up_genes_for_all_possible_groups}} To 
prepare the \bold{de_table.ref.marked} input.
}
