% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasting_functions.r
\name{contrast_the_group_to_the_rest_with_limma_for_microarray}
\alias{contrast_the_group_to_the_rest_with_limma_for_microarray}
\title{contrast_the_group_to_the_rest_with_limma_for_microarray}
\usage{

  contrast_the_group_to_the_rest_with_limma_for_microarray(norm_expression_table,
  sample_sheet_table, the_group, sample_name, extra_factor_name = NA,
  pval_threshold = 0.01)
}
\arguments{
\item{norm_expression_table}{A logged, normalised expression table. Any 
filtering (removal of low-expression probes/genes)}

\item{sample_sheet_table}{Tab-separated text file of sample information.
Columns must have names. Sample/microarray ids should be listed under 
\bold{sample_name} column. The cell-type (or 'group') of each sample should 
be listed under a column \bold{group_name}.}

\item{the_group}{Which query group is being tested.}

\item{sample_name}{Name of \bold{sample_sheet_table} with sample ID}

\item{extra_factor_name}{Optionally, an extra cross-group factor (as column 
name in \bold{sample_sheet_table}) to include in the model used by limma. 
E.g. An  individual/mouse id. Refer limma docs. Default = NA}

\item{pval_threshold}{For reporting only, a p-value threshold. Default = 0.01}
}
\value{
A tibble, the within-experiment de_table (differential expression
table), for the group specified.
}
\description{
Private function used by 
contrast_each_group_to_the_rest_for_norm_ma_with_limma
}
\seealso{
\code{\link{contrast_each_group_to_the_rest_for_norm_ma_with_limma}}
public calling function

\href{https://bioconductor.org/packages/release/bioc/html/limma.html}{Limma}
Limma package for differential expression.
}
