% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{plot_genes}
\alias{plot_genes}
\title{Plot gene variance distributions}
\usage{
plot_genes(object, vmr = NULL, ncexpr = NULL, selected_genes = NULL,
  variable_genes = NULL, mode_genes = NULL, marker_genes = NULL,
  save.memory = FALSE, progress.bar = TRUE, log = "xy", cex = 0.5)
}
\arguments{
\item{object}{Object containing count data}

\item{vmr}{Variance to mean ratio (VMR)}

\item{ncexpr}{Number of cells expressing each gene}

\item{selected_genes}{Logical vector specifing genes selected}

\item{variable_genes}{Logical vector specifing genes with high VMR}

\item{mode_genes}{Logical vector specifying genes with nonzero modes}

\item{marker_genes}{Logical vector specifying marker genes}

\item{save.memory}{If \code{TRUE}, calculate VMR using slower
method to save memory. Not used when gene lists are supplied.}

\item{progress.bar}{Display progress bar for VMR calculation.
Not used when gene lists are supplied.}

\item{log}{Axis in log-scale, \code{c('x','y','xy')}.}

\item{cex}{Symbol size for genes (supplied to \code{plot()}).}
}
\value{
\code{NULL}
}
\description{
Gene variance to mean ratio and the number of expressing cells are
plotted.
}
\details{
This function can be called separately or is also called within
\code{\link{filter_genes}} by default. 
In the latter case, parameters other
than \code{object} will have been already filled. If called separately
with \code{NULL} gene lists, VMR is recalculated but gene selection
is not done.
}
\examples{
set.seed(1)
s <- scNMFSet(matrix(stats::rpois(n=1200,lambda=3),40,30))
plot_genes(s)
}
