% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{filter_genes}
\alias{filter_genes}
\title{Filter genes with quality control criteria}
\usage{
filter_genes(object, markers = NULL, vmr.min = 0,
  min.cells.expressed = 0, max.cells.expressed = Inf,
  rescue.genes = FALSE, progress.bar = TRUE, save.memory = FALSE,
  plot = TRUE, log = "xy", cex = 0.5)
}
\arguments{
\item{object}{\code{scNMFSet} object.}

\item{markers}{A vector containing marker genes to be selected. 
   All rows in 
\code{rowData} that contain columns matching this set will 
   be selected.}

\item{vmr.min}{Minimum variance-to-mean ratio for gene filtering.}

\item{min.cells.expressed}{Minimum no. of cells expressed for gene 
filtering.}

\item{max.cells.expressed}{Maximum no. of cells expressed for gene 
filtering.}

\item{rescue.genes}{Selected additional genes whose (non-zero)
count distributions have at least one mode.}

\item{progress.bar}{Display progress of mode-gene scan or VMR
calculation with \code{save.memory = TRUE}.}

\item{save.memory}{For a very large number of cells, calculate VMR 
row by row while avoiding calls to \code{as.matrix()}.
Progress bar will be displayed unless \code{progress.bar=FALSE}.}

\item{plot}{Plot the distribution of no. of cells expressed vs. VMR.}

\item{log}{Axis in log-scale, \code{c('x','y','xy')}.}

\item{cex}{Symbol size for each gene in the plot.}
}
\value{
Object of class \code{scNMFSet}.
}
\description{
Select genes with high relative variance in count data for 
further analysis
}
\details{
Takes as input \code{scNMFSet} object and scatterplot no. of cells 
expressed versus VMR (variance-to-mean ratio)
for each gene. Optionally, genes are filtered using minimum VMR 
together with a range of no. of cells expressed.
}
\examples{
set.seed(1)
s <- scNMFSet(matrix(stats::rpois(n=1200,lambda=3),40,30))
s <- filter_genes(s,vmr.min=1.0,min.cells.expressed=28,
        rescue.genes=FALSE)
}
