% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{generateUIwidgets}
\alias{generateUIwidgets}
\title{Generate UI input widget}
\usage{
generateUIwidgets(
  colname,
  mode = c("add", "edit"),
  tab = c("Patient", "Sample", "Mutation"),
  data = NULL,
  selected_row = NULL,
  patientIDs = NULL,
  sampleIDs = NULL
)
}
\arguments{
\item{colname}{A character string - the name of the column, that will be the label of the input}

\item{mode}{"add" or "edit" - whether to use existing values or not}

\item{tab}{"Patient", "Sample" - The used tab; sets the html id prefix of the input}

\item{data}{A data.frame.}

\item{selected_row}{A number indicating the row number of the selected row in the data.frame.}

\item{patientIDs}{Vector of patient IDs used for drop down menu of the PATIENT_ID column}
}
\value{
A sanitized string.
}
\description{
Generate UI input widget
}
\examples{
cbpManager:::generateUIwidgets(colname = "attribute", mode = "add", tab = "Patient")

}
