% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_data.R
\name{read_vcf}
\alias{read_vcf}
\title{Read a VCF file into R session}
\usage{
read_vcf(
  vcf_file,
  genome = "GRCh37",
  seq_levels_style = "Ensembl",
  verbose = TRUE
)
}
\arguments{
\item{vcf_file}{character(1), path to VCF file to read into R session as a
\code{\link[VariantAnnotation]{CollapsedVCF}} object}

\item{genome}{character(1), string indicating the genome build used in the
VCF file(s) (default: "GRCh37")}

\item{seq_levels_style}{character(1), string passed to
\code{\link[GenomeInfoDb]{seqlevelsStyle}} the style to use for
chromosome/contig names (default: "Ensembl")}

\item{verbose}{logical(1), should messages be printed as function runs?}
}
\value{
a vcf object
}
\description{
Read a VCF file into R session
}
\examples{
vcf <- read_vcf(system.file("extdata", "cells.donorid.vcf.gz",
               package = "cardelino"))

}
