% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMap.R
\name{prepareCMapPerturbations}
\alias{prepareCMapPerturbations}
\title{Prepare CMap perturbation data}
\usage{
prepareCMapPerturbations(
  metadata,
  zscores,
  geneInfo,
  compoundInfo = NULL,
  ...,
  loadZscores = FALSE
)
}
\arguments{
\item{metadata}{Data frame (CMap metadata) or character (respective filepath
to load data from file)}

\item{zscores}{Data frame (GCTX z-scores) or character (respective filepath
to load data from file)}

\item{geneInfo}{Data frame (CMap gene info) or character (respective
filepath to load data from file)}

\item{compoundInfo}{Data frame (CMap compound info) or character (respective
filepath to load data from file)}

\item{...}{
  Arguments passed on to \code{\link[=filterCMapMetadata]{filterCMapMetadata}}
  \describe{
    \item{\code{cellLine}}{Character: cell line (if \code{NULL}, all values are loaded)}
    \item{\code{timepoint}}{Character: timepoint (if \code{NULL}, all values are loaded)}
    \item{\code{dosage}}{Character: dosage (if \code{NULL}, all values are loaded)}
    \item{\code{perturbationType}}{Character: type of perturbation (if \code{NULL}, all
perturbation types are loaded)}
  }}

\item{loadZscores}{Boolean: load matrix of perturbation z-scores? Not
recommended in systems with less than 30GB of RAM; if \code{FALSE},
downstream functions will load and process the file directly chunk by
chunk, resulting in a lower memory footprint}
}
\value{
CMap perturbation data attributes and filename
}
\description{
Prepare CMap perturbation data
}
\examples{
metadata <- loadCMapData("cmapMetadata.txt", "metadata")
metadata <- filterCMapMetadata(metadata, cellLine="HepG2")
\dontrun{
prepareCMapPerturbations(metadata, "cmapZscores.gctx", "cmapGeneInfo.txt")
}
}
\seealso{
Other functions related with the ranking of CMap perturbations: 
\code{\link{as.table.referenceComparison}()},
\code{\link{filterCMapMetadata}()},
\code{\link{getCMapConditions}()},
\code{\link{getCMapPerturbationTypes}()},
\code{\link{loadCMapData}()},
\code{\link{loadCMapZscores}()},
\code{\link{parseCMapID}()},
\code{\link{plot.perturbationChanges}()},
\code{\link{plot.referenceComparison}()},
\code{\link{plotTargetingDrugsVSsimilarPerturbations}()},
\code{\link{print.similarPerturbations}()},
\code{\link{rankSimilarPerturbations}()}
}
\concept{functions related with the ranking of CMap perturbations}
