% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ontology.R
\name{subsetByOntology}
\alias{subsetByOntology}
\title{Ontology-based subsetting of BugSigDB signatures}
\usage{
subsetByOntology(df, column = c("Body site", "Condition"), term, ontology)
}
\arguments{
\item{df}{\code{data.frame} storing BugSigDB data. Typically obtained via
\code{\link{importBugSigDB}}.}

\item{column}{character. Column of \code{df} on which subsetting should be
performed. Should be either \code{"Body site"} (default) or \code{"Condition"}.}

\item{term}{character. A valid term of \code{ontology}. Subsetting by this term
then involves subsetting \code{column} to this term and all descendants of that
term in the the chosen \code{ontology} and that are present in the chosen
\code{column} of \code{df}.}

\item{ontology}{an object of class \code{ontology_index} as defined in the
ontologyIndex package. Typically obtained via \code{\link{getOntology}}.}
}
\value{
a \code{data.frame} with the chosen column restricted to descendants
of the chosen term in the chosen ontology.
}
\description{
This function facilitates ontology-based queries for experimental
factors and body sites.
}
\examples{

 # (1) Obtain BugSigDB data
 df <- importBugSigDB()

 # (2) Obtain ontology of interest as an R object
 uberon <- getOntology("uberon")

 # (3) High-level query on body site
 sdf <- subsetByOntology(df, 
                         column = "Body site",
                         term = "digestive system element",
                         ontology = uberon)
 table(sdf[,"Body site"])

}
\references{
EFO: \url{https://www.ebi.ac.uk/ols/ontologies/efo}

 UBERON: \url{https://www.ebi.ac.uk/ols/ontologies/uberon}
}
\seealso{
\code{importBugSigDB}, \code{getOntology}
}
