% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brendaEntry.R
\name{InitBrendaDeprecatedEntry}
\alias{InitBrendaDeprecatedEntry}
\alias{is.brenda.deprecated.entry}
\title{Create a \code{brenda.deprecated.entry} object.}
\usage{
InitBrendaDeprecatedEntry(EC, msg)

is.brenda.deprecated.entry(x)
}
\arguments{
\item{EC}{A string indicating EC number of the enzyme.}

\item{msg}{A string of the transferred / deleted message.}

\item{x}{Any object.}
}
\value{
A \code{brenda.deprecated.entry} obeject.

A boolean vector of the same length as \code{x}.
}
\description{
Some EC numbers are transferred or deleted. For these entries,
return a \code{brenda.deprecated.entry} object and the corresponding message.
}
\details{
\code{is.brenda.deprecated.entry} checks if an object is a
\code{brenda.deprecated.entry} object. If the input is a \code{brenda.entries} object,
check all items in the list to see if they are \code{brenda.deprecated.entry}
objects and return a boolean vector of the same length.
}
\examples{
brendaDb:::InitBrendaDeprecatedEntry("6.3.5.8", "Transferred to EC 2.6.1.85")
df <- ReadBrenda(system.file("extdata", "brenda_download_test.txt",
                          package = "brendaDb"))
is.brenda.entry(QueryBrenda(df, "6.3.5.8"))

}
\keyword{internal}
