% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaWCalculator.R
\name{deltaWCalculator}
\alias{deltaWCalculator}
\title{Calculate deltaWs}
\usage{
deltaWCalculator(frags, reads.per.window = 100)
}
\arguments{
\item{frags}{A \code{\link{GRanges-class}} with read fragments (see \code{\link{readBamFileAsGRanges}}).}

\item{reads.per.window}{Number of reads in each dynamic window.}
}
\value{
The input \code{frags} with additional meta-data columns.
}
\description{
This function will calculate deltaWs from a \code{\link{GRanges-class}} object with read fragments.
}
\examples{
## Get an example file
exampleFolder <- system.file("extdata", "example_bams", package="breakpointRdata")
exampleFile <- list.files(exampleFolder, full.names=TRUE)[1]
## Load the file
fragments <- readBamFileAsGRanges(exampleFile, pairedEndReads=FALSE, chromosomes='chr22')
## Calculate deltaW values
dw <- deltaWCalculator(fragments)

}
\seealso{
readBamFileAsGRanges
}
\author{
Aaron Taudt
}
