% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarizeBsSeqOver.R
\name{summarizeBsSeqOver}
\alias{summarizeBsSeqOver}
\title{Summarize methylation over provided regions}
\usage{
summarizeBsSeqOver(bsseq, segs, dropNA = FALSE, impute = FALSE)
}
\arguments{
\item{bsseq}{The bsseq object to summarize}

\item{segs}{Regions to summarize over (GRanges object, no GRangesList yet)}

\item{dropNA}{Whether to drop rows if more than half of samples are NA
(DEFAULT: FALSE)}

\item{impute}{Whether to impute NAs/NaNs (DEFAULT: FALSE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{   A matrix of regional methylation fractions
}\if{html}{\out{</div>}}
}
\description{
Used for bsseq objects. Mostly a local wrapp for getMeth.
}
\examples{

  orig_bed <- system.file("extdata", "MCF7_Cunha_chr11p15.bed.gz",
                          package="biscuiteer")
  orig_vcf <- system.file("extdata", "MCF7_Cunha_header_only.vcf.gz",
                          package="biscuiteer")
  bisc <- readBiscuit(BEDfile = orig_bed, VCFfile = orig_vcf,
                      merged = FALSE)

  reg <- GRanges(seqnames = rep("chr11",5),
                 strand = rep("*",5),
                 ranges = IRanges(start = c(0,2.8e6,1.17e7,1.38e7,1.69e7),
                                  end= c(2.8e6,1.17e7,1.38e7,1.69e7,2.2e7))
                )
  summary <- summarizeBsSeqOver(bsseq = bisc, segs = reg, dropNA = TRUE)

}
