% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biosign-methods.R
\name{getEset,biosign-method}
\alias{getEset,biosign-method}
\alias{getEset}
\alias{getEset,}
\alias{biosign-method}
\title{getEset method}
\usage{
\S4method{getEset}{biosign}(object)
}
\arguments{
\item{object}{An S4 object of class \code{biosign}, created by \code{biosign}
function.}
}
\value{
An S4 object of class \code{ExpressionSet} which contains the dataMatrix (t(exprs(eset))),
and the sampleMetadata (pData(eset)) and variableMetadata (fData(eset)) with the additional columns
containing the computed tiers for each feature and each classifier.
}
\description{
Extracts the complemented ExpressionSet when biosign has been applied to an ExpressionSet
}
\examples{

## loading the diaplasma dataset

data(diaplasma)
attach(diaplasma)

## building the ExpresssionSet instance

diaSet <- Biobase::ExpressionSet(assayData = t(dataMatrix), 
                                 phenoData = new("AnnotatedDataFrame", 
                                                 data = sampleMetadata), 
                                 featureData = new("AnnotatedDataFrame", 
                                                   data = variableMetadata),
                                 experimentData = new("MIAME", 
                                                      title = "diaplasma"))

## restricting to a smaller dataset for this example

featureSelVl <- variableMetadata[, "mzmed"] >= 490 & variableMetadata[, "mzmed"] < 500
diaSet <- diaSet[featureSelVl, ]

## signature selection for all 3 classifiers
## a bootI = 5 number of bootstraps is used for this example
## we recommend to keep the default bootI = 50 value for your analyzes

set.seed(123)
diaSign <- biosign(diaSet, "type", bootI = 5)

diaSet <- biosigner::getEset(diaSign)
head(Biobase::pData(diaSet))
head(Biobase::fData(diaSet))

detach(diaplasma)

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
