% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/biosign-methods.R
\name{getBiosign}
\alias{getBiosign}
\alias{getBiosign,SummarizedExperiment-method}
\alias{getBiosign,MultiAssayExperiment-method}
\title{Getting the biosigner signature from the SummarizedExperiment object}
\usage{
getBiosign(object)

\S4method{getBiosign}{SummarizedExperiment}(object)

\S4method{getBiosign}{MultiAssayExperiment}(object)
}
\arguments{
\item{object}{An S4 object of class \code{SummarizedExperiment}, once processed by the \code{biosign}
method}
}
\value{
List of biosigner outputs contained in the SummarizedExperiment object
}
\description{
The models are extracted as a list
}
\examples{

# Getting the diaplasma data set as a SummarizedExperiment

data(diaplasma)

diaplasma.se <- SummarizedExperiment::SummarizedExperiment(assays = list(diaplasma = t(diaplasma[["dataMatrix"]])),
                                                           colData = diaplasma[["sampleMetadata"]],
                                                           rowData = diaplasma[["variableMetadata"]])

diaplasma.se <- diaplasma.se[1:100, ]

# Selecting the features

diaplasma.se <- biosign(diaplasma.se, "type", bootI = 5, fig.pdfC = "none")

# Getting the signatures

diaplasma.biosign <- getBiosign(diaplasma.se)[["type_plsda.forest.svm"]]

diaplasma.biosign

}
\author{
Etienne Thevenot, \email{etienne.thevenot@cea.fr}
}
