% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biomaRt.R
\name{getLDS}
\alias{getLDS}
\title{Retrieves information from two linked datasets}
\usage{
getLDS(
  attributes,
  filters = "",
  values = "",
  mart,
  attributesL,
  filtersL = "",
  valuesL = "",
  martL,
  verbose = FALSE,
  uniqueRows = TRUE,
  bmHeader = TRUE
)
}
\arguments{
\item{attributes}{Attributes you want to retrieve of primary dataset.  A
possible list of attributes can be retrieved using the function
\code{\link[=listAttributes]{listAttributes()}}.}

\item{filters}{Filters that should be used in the query. These filters will
be applied to primary dataset.  A possible list of filters can be retrieved
using the function \code{\link[=listFilters]{listFilters()}}.}

\item{values}{Values of the filter, e.g. list of affy IDs}

\item{mart}{object of class Mart created with the \code{\link[=useMart]{useMart()}} function.}

\item{attributesL}{Attributes of linked dataset that needs to be retrieved}

\item{filtersL}{Filters to be applied to the linked dataset}

\item{valuesL}{Values for the linked dataset filters}

\item{martL}{Mart object representing linked dataset}

\item{verbose}{When using \pkg{biomaRt} in webservice mode and setting
verbose to \code{TRUE}, the XML query to the webservice will be printed.
Alternatively in MySQL mode the MySQL query will be printed.}

\item{uniqueRows}{Logical to indicate if the BioMart web service should
return unique rows only or not.  Has the value of either \code{TRUE} or \code{FALSE}}

\item{bmHeader}{Boolean to indicate if the result retrieved from the BioMart
server should include the data headers or not, defaults to \code{TRUE}.  This
should only be switched off if the default behavior results in errors,
setting to off might still be able to retrieve your data in that case}
}
\description{
This function is the main biomaRt query function that links 2 datasets and
retrieves information from these linked BioMart datasets.  In Ensembl this
translates to homology mapping.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
human <- useMart(
  "ENSEMBL_MART_ENSEMBL",
  dataset = "hsapiens_gene_ensembl",
  host = "https://dec2021.archive.ensembl.org"
)
mouse <- useMart(
  "ENSEMBL_MART_ENSEMBL",
  dataset = "mmusculus_gene_ensembl",
  host = "https://dec2021.archive.ensembl.org"
)
getLDS(
  attributes = c("hgnc_symbol","chromosome_name", "start_position"),
  filters = "hgnc_symbol",
  values = "TP53",
  mart = human,
  attributesL = c("chromosome_name","start_position"),
  martL = mouse
)
\dontshow{\}) # examplesIf}
}
\author{
Steffen Durinck
}
\keyword{methods}
