% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exportFASTA.R
\name{exportFASTA}
\alias{exportFASTA}
\title{Exports getSequence results to FASTA format}
\usage{
exportFASTA(sequences, file)
}
\arguments{
\item{sequences}{A data.frame that was the output of the \code{\link[=getSequence]{getSequence()}}
function}

\item{file}{File to which you want to write the data}
}
\description{
Exports getSequence results to FASTA format
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
mart <- useMart("ENSEMBL_MART_ENSEMBL", dataset = "hsapiens_gene_ensembl")

seq <- getSequence(
  id = "BRCA1",
  type = "hgnc_symbol",
  seqType = "cdna",
  mart = mart
)
exportFASTA(seq, file = "test.fasta")
\dontshow{\}) # examplesIf}
}
\author{
Steffen Durinck

Hugo Gruson
}
\keyword{methods}
