% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbFactory.R
\name{BiodbFactory}
\alias{BiodbFactory}
\title{A class for constructing biodb objects.}
\description{
A class for constructing biodb objects.

A class for constructing biodb objects.
}
\details{
This class is responsible for the creation of database connectors and
database entries. You must go through the single instance of this class to
create and get connectors, as well as instantiate entries. To get the single
instance of this class, call the \code{getFactory()} method of class
\code{BiodbMain}.
}
\examples{
# Create a BiodbMain instance with default settings:
mybiodb <- biodb::newInst()

# Obtain the factory instance:
factory <- mybiodb$getFactory()

# Get a compound CSV file database
chebi.tsv <- system.file("extdata", "chebi_extract.tsv", package='biodb')

# Create a connector:
conn <- mybiodb$getFactory()$createConn('comp.csv.file', url=chebi.tsv)

# Get a database entry:
entry <- conn$getEntry(conn$getEntryIds(1))

# Terminate instance.
mybiodb$terminate()

}
\seealso{
\code{\link{BiodbMain}}, \code{\link{BiodbConn}} and
\code{\link{BiodbEntry}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbFactory-new}{\code{BiodbFactory$new()}}
\item \href{#method-BiodbFactory-getBiodb}{\code{BiodbFactory$getBiodb()}}
\item \href{#method-BiodbFactory-createConn}{\code{BiodbFactory$createConn()}}
\item \href{#method-BiodbFactory-connExists}{\code{BiodbFactory$connExists()}}
\item \href{#method-BiodbFactory-deleteConn}{\code{BiodbFactory$deleteConn()}}
\item \href{#method-BiodbFactory-deleteConnByClass}{\code{BiodbFactory$deleteConnByClass()}}
\item \href{#method-BiodbFactory-getAllConnectors}{\code{BiodbFactory$getAllConnectors()}}
\item \href{#method-BiodbFactory-deleteAllConnectors}{\code{BiodbFactory$deleteAllConnectors()}}
\item \href{#method-BiodbFactory-getConn}{\code{BiodbFactory$getConn()}}
\item \href{#method-BiodbFactory-getEntry}{\code{BiodbFactory$getEntry()}}
\item \href{#method-BiodbFactory-createNewEntry}{\code{BiodbFactory$createNewEntry()}}
\item \href{#method-BiodbFactory-createEntryFromContent}{\code{BiodbFactory$createEntryFromContent()}}
\item \href{#method-BiodbFactory-getAllCacheEntries}{\code{BiodbFactory$getAllCacheEntries()}}
\item \href{#method-BiodbFactory-deleteAllEntriesFromVolatileCache}{\code{BiodbFactory$deleteAllEntriesFromVolatileCache()}}
\item \href{#method-BiodbFactory-deleteAllCacheEntries}{\code{BiodbFactory$deleteAllCacheEntries()}}
\item \href{#method-BiodbFactory-print}{\code{BiodbFactory$print()}}
\item \href{#method-BiodbFactory-clone}{\code{BiodbFactory$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. The BiodbFactory class must not be instantiated
directly.
Instead, call the getFactory() method from the BiodbMain instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$new(bdb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bdb}}{The BiodbMain instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-getBiodb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-getBiodb}{}}}
\subsection{Method \code{getBiodb()}}{
Returns the biodb main class instance to which this object is
attached.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$getBiodb()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The main biodb instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-createConn"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-createConn}{}}}
\subsection{Method \code{createConn()}}{
Creates a connector to a database.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$createConn(
  db.class,
  url = NULL,
  token = NA_character_,
  fail.if.exists = TRUE,
  get.existing.conn = TRUE,
  conn.id = NULL,
  cache.id = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.class}}{The type of a database. The list of types can be
obtained from the class BiodbDbsInfo.}

\item{\code{url}}{An URL to the database for which to create a connection.
Each database connector is configured with a default URL, but some
allow you to change it.}

\item{\code{token}}{A security access token for the database. Some database
require such a token for all or some of their webservices. Usually you
obtain the token through your account on the database website.}

\item{\code{fail.if.exists}}{If set to TRUE, the method will fail if a
connector for}

\item{\code{get.existing.conn}}{This argument will be used only if
fail.if.exists is set to FALSE and an identical connector already
exists. If it set to TRUE, the existing connector instance will be
returned, otherwise NULL will be returned.}

\item{\code{conn.id}}{If set, this identifier will be used for the new
connector. An error will be raised in case another connector already
exists with this identifier.}

\item{\code{cache.id}}{If set, this ID will be used as the cache ID for the
new connector. An error will be raised in case another connector
already exists with this cache identifier.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An instance of the requested connector class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-connExists"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-connExists}{}}}
\subsection{Method \code{connExists()}}{
Tests if a connector exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$connExists(conn.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{A connector ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if a connector with this ID exists, FALSE otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-deleteConn"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-deleteConn}{}}}
\subsection{Method \code{deleteConn()}}{
Deletes an existing connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$deleteConn(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A connector instance or a connector ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-deleteConnByClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-deleteConnByClass}{}}}
\subsection{Method \code{deleteConnByClass()}}{
Deletes all existing connectors from a same class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$deleteConnByClass(db.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.class}}{The type of a database. All connectors of this
database type will be deleted.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-getAllConnectors"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-getAllConnectors}{}}}
\subsection{Method \code{getAllConnectors()}}{
Gets all connectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$getAllConnectors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of all created connectors.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-deleteAllConnectors"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-deleteAllConnectors}{}}}
\subsection{Method \code{deleteAllConnectors()}}{
Deletes all connectors.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$deleteAllConnectors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-getConn"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-getConn}{}}}
\subsection{Method \code{getConn()}}{
Gets an instantiated connector instance, or create a new one.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$getConn(conn.id, class = TRUE, create = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{An existing connector ID.}

\item{\code{class}}{If set to TRUE, and \"conn.id\" does not correspond to
any instantiated connector, then interpret \"conn.id\" as a database
class and looks for the first instantiated connector of that class.}

\item{\code{create}}{If set to TRUE, and \"class\" is also set to TRUE, and
no suitable instantiated connector was found, then creates a new
connector instance of the class specified by \"conn.id\".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The connector instance corresponding to the connector ID or to
the database ID submitted (if class \"parameter\" is set to TRUE).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-getEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-getEntry}{}}}
\subsection{Method \code{getEntry()}}{
Retrieves database entry objects from IDs (accession numbers), for the
specified connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$getEntry(conn.id, id, drop = TRUE, no.null = FALSE, limit = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{An existing connector ID.}

\item{\code{id}}{A character vector containing database entry IDs (accession
numbers).}

\item{\code{drop}}{If set to TRUE and the list of entries contains only one
element, then returns this element instead of the list. If set to
FALSE, then returns always a list.}

\item{\code{no.null}}{Set to TRUE to remove NULL entries.}

\item{\code{limit}}{Set to a positive value to limit the number of entries
returned.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of BiodbEntry objects, the same length as \code{id}. A
NULL value is put into the list for each invalid ID of \code{id}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-createNewEntry"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-createNewEntry}{}}}
\subsection{Method \code{createNewEntry()}}{
Creates a new empty entry object from scratch. This entry is not stored in
cache, and is directly attached to the factory instance instead of a
particular connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$createNewEntry(db.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{db.class}}{A database ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new BiodbEntry object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-createEntryFromContent"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-createEntryFromContent}{}}}
\subsection{Method \code{createEntryFromContent()}}{
Creates an entry instance from a content.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$createEntryFromContent(conn.id, content, drop = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{A valid BiodbConn identifier.}

\item{\code{content}}{A list or character vector of contents to parse to create the
entries.}

\item{\code{drop}}{If set to TRUE}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of new BiodbEntry objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-getAllCacheEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-getAllCacheEntries}{}}}
\subsection{Method \code{getAllCacheEntries()}}{
For a connector, gets all entries stored in the cache.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$getAllCacheEntries(conn.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{A connector ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of BiodbEntry objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-deleteAllEntriesFromVolatileCache"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-deleteAllEntriesFromVolatileCache}{}}}
\subsection{Method \code{deleteAllEntriesFromVolatileCache()}}{
Deletes all entries stored in the cache of the given connector. This
method is deprecated, please use deleteAllEntriesFromVolatileCache()
instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$deleteAllEntriesFromVolatileCache(conn.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{A connector ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-deleteAllCacheEntries"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-deleteAllCacheEntries}{}}}
\subsection{Method \code{deleteAllCacheEntries()}}{
Deletes all entries stored in the cache of the given connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$deleteAllCacheEntries(conn.id)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.id}}{A connector ID.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-print}{}}}
\subsection{Method \code{print()}}{
Prints information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbFactory-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbFactory-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbFactory$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
