% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbConnBase.R
\name{BiodbConnBase}
\alias{BiodbConnBase}
\title{Base class of \code{BiodbConn} for encapsulating all needed information for
database access.}
\description{
Base class of \code{BiodbConn} for encapsulating all needed information for
database access.

Base class of \code{BiodbConn} for encapsulating all needed information for
database access.
}
\details{
This is the base class for \code{BiodbConn} and \code{BiodbDbInfo}.
When defining a new connector class, your class must not inherit from
\code{BiodbBaseConn} but at least from \code{BiodbConn} (or
\code{BiodbRemoteConn} or any subclass of \code{BiodbConn}).
Its main purpose is to store property values. Those values are initialized
from YAML files. The default definition file is located inside the package
in "inst/definitions.yml" and is loaded at Biodb startup. However you can
define your own files and load them using the
\code{BiodbMain::loadDefinitions()} method.

Arguments to the contructor are:

other: Another object inheriting from \code{BiodbBaseConn}, and
from which property values will be copied.

db.class: The class of the database (\code{"mass.csv.file"},
\code{"comp.csv.file"}, ...).

properties: Some properties to set at initialization.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Accessing BiodbConnBase methods when using a BiodbDbInfo object
dbinf <- mybiodb$getDbsInfo()$get('comp.csv.file')

# Test if a property exists
dbinf$hasProp('name')

# Get a property value
dbinf$getPropertyValue('name')

# Get a property value slot
dbinf$getPropValSlot('urls', 'base.url')

# Terminate instance.
mybiodb$terminate()

}
\seealso{
Sub-classes \code{\link{BiodbDbInfo}} and \code{\link{BiodbConn}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbConnBase-new}{\code{BiodbConnBase$new()}}
\item \href{#method-BiodbConnBase-print}{\code{BiodbConnBase$print()}}
\item \href{#method-BiodbConnBase-hasProp}{\code{BiodbConnBase$hasProp()}}
\item \href{#method-BiodbConnBase-getPropSlots}{\code{BiodbConnBase$getPropSlots()}}
\item \href{#method-BiodbConnBase-hasPropSlot}{\code{BiodbConnBase$hasPropSlot()}}
\item \href{#method-BiodbConnBase-propExists}{\code{BiodbConnBase$propExists()}}
\item \href{#method-BiodbConnBase-isSlotProp}{\code{BiodbConnBase$isSlotProp()}}
\item \href{#method-BiodbConnBase-getPropValSlot}{\code{BiodbConnBase$getPropValSlot()}}
\item \href{#method-BiodbConnBase-updatePropertiesDefinition}{\code{BiodbConnBase$updatePropertiesDefinition()}}
\item \href{#method-BiodbConnBase-getEntryFileExt}{\code{BiodbConnBase$getEntryFileExt()}}
\item \href{#method-BiodbConnBase-getDbClass}{\code{BiodbConnBase$getDbClass()}}
\item \href{#method-BiodbConnBase-getConnClassName}{\code{BiodbConnBase$getConnClassName()}}
\item \href{#method-BiodbConnBase-getConnClass}{\code{BiodbConnBase$getConnClass()}}
\item \href{#method-BiodbConnBase-getEntryClassName}{\code{BiodbConnBase$getEntryClassName()}}
\item \href{#method-BiodbConnBase-getEntryClass}{\code{BiodbConnBase$getEntryClass()}}
\item \href{#method-BiodbConnBase-getEntryIdField}{\code{BiodbConnBase$getEntryIdField()}}
\item \href{#method-BiodbConnBase-getPropertyValue}{\code{BiodbConnBase$getPropertyValue()}}
\item \href{#method-BiodbConnBase-setPropertyValue}{\code{BiodbConnBase$setPropertyValue()}}
\item \href{#method-BiodbConnBase-setPropValSlot}{\code{BiodbConnBase$setPropValSlot()}}
\item \href{#method-BiodbConnBase-getBaseUrl}{\code{BiodbConnBase$getBaseUrl()}}
\item \href{#method-BiodbConnBase-setBaseUrl}{\code{BiodbConnBase$setBaseUrl()}}
\item \href{#method-BiodbConnBase-getWsUrl}{\code{BiodbConnBase$getWsUrl()}}
\item \href{#method-BiodbConnBase-setWsUrl}{\code{BiodbConnBase$setWsUrl()}}
\item \href{#method-BiodbConnBase-getToken}{\code{BiodbConnBase$getToken()}}
\item \href{#method-BiodbConnBase-setToken}{\code{BiodbConnBase$setToken()}}
\item \href{#method-BiodbConnBase-getName}{\code{BiodbConnBase$getName()}}
\item \href{#method-BiodbConnBase-getEntryContentType}{\code{BiodbConnBase$getEntryContentType()}}
\item \href{#method-BiodbConnBase-getSchedulerNParam}{\code{BiodbConnBase$getSchedulerNParam()}}
\item \href{#method-BiodbConnBase-setSchedulerNParam}{\code{BiodbConnBase$setSchedulerNParam()}}
\item \href{#method-BiodbConnBase-getSchedulerTParam}{\code{BiodbConnBase$getSchedulerTParam()}}
\item \href{#method-BiodbConnBase-setSchedulerTParam}{\code{BiodbConnBase$setSchedulerTParam()}}
\item \href{#method-BiodbConnBase-getUrls}{\code{BiodbConnBase$getUrls()}}
\item \href{#method-BiodbConnBase-getUrl}{\code{BiodbConnBase$getUrl()}}
\item \href{#method-BiodbConnBase-setUrl}{\code{BiodbConnBase$setUrl()}}
\item \href{#method-BiodbConnBase-getXmlNs}{\code{BiodbConnBase$getXmlNs()}}
\item \href{#method-BiodbConnBase-clone}{\code{BiodbConnBase$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. Connector objects must not be created directly.
Instead, you create new connector instances through the BiodbFactory
instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$new(other = NULL, db.class = NULL, properties = NULL, cfg = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{other}}{Another BiodbConnBase instance as a model from which to
copy property values.}

\item{\code{db.class}}{The class of the connector (i.e.: "mass.csv.file").}

\item{\code{properties}}{Some new values for the properties.}

\item{\code{cfg}}{The BiodbConfig instance from which will be taken some
property values.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-print}{}}}
\subsection{Method \code{print()}}{
Prints a description of this connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-hasProp"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-hasProp}{}}}
\subsection{Method \code{hasProp()}}{
Tests if this connector has a property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$hasProp(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the property to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns true if the property \code{name} exists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getPropSlots"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getPropSlots}{}}}
\subsection{Method \code{getPropSlots()}}{
Gets the slot fields of a property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getPropSlots(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a property.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns a character vector containing all slot names
defined.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-hasPropSlot"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-hasPropSlot}{}}}
\subsection{Method \code{hasPropSlot()}}{
Tests if a slot property has a specific slot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$hasPropSlot(name, slot)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a property.}

\item{\code{slot}}{The slot name to check.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the property \code{name} exists and has the
slot \code{slot} defined, and FALSE otherwise."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-propExists"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-propExists}{}}}
\subsection{Method \code{propExists()}}{
Checks if property exists.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$propExists(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a property.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the property \code{name} exists, and FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-isSlotProp"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-isSlotProp}{}}}
\subsection{Method \code{isSlotProp()}}{
Tests if a property is a slot property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$isSlotProp(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a property.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Returns TRUE if the property is a slot propert, FALSE
otherwise.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getPropValSlot"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getPropValSlot}{}}}
\subsection{Method \code{getPropValSlot()}}{
Retrieve the value of a slot of a property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getPropValSlot(name, slot, hook = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of a property.}

\item{\code{slot}}{The slot name inside the property.}

\item{\code{hook}}{If set to TRUE, enables the calls to hook methods
associated with the property. Otherwise, all calls to hook
methods are disabled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the slot \code{slot} of the property \code{name}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-updatePropertiesDefinition"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-updatePropertiesDefinition}{}}}
\subsection{Method \code{updatePropertiesDefinition()}}{
Update the definition of properties.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$updatePropertiesDefinition(def)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{def}}{A named list of property definitions. The names of the list must
be the property names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getEntryFileExt"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getEntryFileExt}{}}}
\subsection{Method \code{getEntryFileExt()}}{
Returns the entry file extension used by this connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getEntryFileExt()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character value containing the file extension.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getDbClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getDbClass}{}}}
\subsection{Method \code{getDbClass()}}{
Gets the Biodb name of the database associated with this connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getDbClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character value containing the Biodb database name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getConnClassName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getConnClassName}{}}}
\subsection{Method \code{getConnClassName()}}{
Gets the name of the associated connector OOP class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getConnClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the connector OOP class name.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getConnClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getConnClass}{}}}
\subsection{Method \code{getConnClass()}}{
Gets the associated connector OOP class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getConnClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the connector OOP class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getEntryClassName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getEntryClassName}{}}}
\subsection{Method \code{getEntryClassName()}}{
Gets the name of the associated entry class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getEntryClassName()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the name of the associated entry class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getEntryClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getEntryClass}{}}}
\subsection{Method \code{getEntryClass()}}{
Gets the associated entry class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getEntryClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the associated entry class.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getEntryIdField"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getEntryIdField}{}}}
\subsection{Method \code{getEntryIdField()}}{
Gets the name of the corresponding database ID field in entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getEntryIdField()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the name of the database ID field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getPropertyValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getPropertyValue}{}}}
\subsection{Method \code{getPropertyValue()}}{
Gets a property value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getPropertyValue(name, hook = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the property.}

\item{\code{hook}}{If set to TRUE, enables the calls to hook methods
associated with the property. Otherwise, all calls to hook
methods are disabled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The value of the property.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setPropertyValue"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setPropertyValue}{}}}
\subsection{Method \code{setPropertyValue()}}{
Sets the value of a property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setPropertyValue(name, value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the property.}

\item{\code{value}}{The new value to set the property to.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setPropValSlot"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setPropValSlot}{}}}
\subsection{Method \code{setPropValSlot()}}{
Set the value of the slot of a property.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setPropValSlot(name, slot, value, hook = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the property.}

\item{\code{slot}}{The name of the property's slot.}

\item{\code{value}}{The new value to set the property's slot to.}

\item{\code{hook}}{If set to TRUE, enables the calls to hook methods
associated with the property. Otherwise, all calls to hook
methods are disabled.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getBaseUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getBaseUrl}{}}}
\subsection{Method \code{getBaseUrl()}}{
Returns the base URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getBaseUrl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
THe baae URL.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setBaseUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setBaseUrl}{}}}
\subsection{Method \code{setBaseUrl()}}{
Sets the base URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setBaseUrl(url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A URL as a character value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getWsUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getWsUrl}{}}}
\subsection{Method \code{getWsUrl()}}{
Returns the web sevices URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getWsUrl()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setWsUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setWsUrl}{}}}
\subsection{Method \code{setWsUrl()}}{
Sets the web sevices URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setWsUrl(ws.url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ws.url}}{A URL as a character value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getToken"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getToken}{}}}
\subsection{Method \code{getToken()}}{
Returns the access token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getToken()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setToken"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setToken}{}}}
\subsection{Method \code{setToken()}}{
Sets the access token.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setToken(token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{token}}{The token to use to access the database, as a character value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getName"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getName}{}}}
\subsection{Method \code{getName()}}{
Returns the full database name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getName()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getEntryContentType"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getEntryContentType}{}}}
\subsection{Method \code{getEntryContentType()}}{
Returns the entry content type.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getEntryContentType()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getSchedulerNParam"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getSchedulerNParam}{}}}
\subsection{Method \code{getSchedulerNParam()}}{
Returns the N parameter for the scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getSchedulerNParam()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setSchedulerNParam"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setSchedulerNParam}{}}}
\subsection{Method \code{setSchedulerNParam()}}{
Sets the N parameter for the scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setSchedulerNParam(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{The N parameter as a whole number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getSchedulerTParam"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getSchedulerTParam}{}}}
\subsection{Method \code{getSchedulerTParam()}}{
Returns the T parameter for the scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getSchedulerTParam()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setSchedulerTParam"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setSchedulerTParam}{}}}
\subsection{Method \code{setSchedulerTParam()}}{
Sets the T parameter for the scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setSchedulerTParam(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{The T parameter as a whole number.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getUrls"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getUrls}{}}}
\subsection{Method \code{getUrls()}}{
Returns the URLs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getUrls()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Returns a URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getUrl(name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the URL to retrieve.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The URL as a character value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-setUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-setUrl}{}}}
\subsection{Method \code{setUrl()}}{
Sets a URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$setUrl(name, url)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{The name of the URL to set.}

\item{\code{url}}{The URL value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-getXmlNs"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-getXmlNs}{}}}
\subsection{Method \code{getXmlNs()}}{
Returns the XML namespace.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$getXmlNs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbConnBase-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbConnBase-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbConnBase$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
