% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metabologram.R
\name{metabologram}
\alias{metabologram}
\title{Circular plot of hierarchital data of genetic profile.}
\usage{
metabologram(treeData,width=600,height=600,main="",showLegend=FALSE,
                     legendBreaks=NULL,
                     legendColors=NULL,
                      fontSize=12,
                     legendText="Legend")
}
\arguments{
\item{treeData}{A hierarchical tree data as in example}

\item{width}{600}

\item{height}{600}

\item{main}{Title}

\item{showLegend}{FALSE}

\item{legendBreaks}{NULL}

\item{legendColors}{NULL}

\item{fontSize}{12}

\item{legendText}{Legend}
}
\value{
A circular layout with genetic profile.
}
\description{
Circular plot of hierarchital data of genetic profile.
}
\examples{
How <- "runManually"
\dontrun{
 metabologram(treeData = sampleWheelData, width=600,
 height=600, main="title", showLegend = TRUE, fontSize = 10,
 legendBreaks=c("NA","Min","Negative", "0", "Positive", "Max"),
 legendColors=c("black","blue","cyan","white","yellow","red") ,
 legendText="Legend")
 }

}
\seealso{
https://github.com/armish/metabologram
}
