% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getListProfData.R
\name{getListProfData}
\alias{getListProfData}
\title{get list of data frame with profiles data (CNA,mRNA, Methylation, Mutation...)}
\usage{
getListProfData(checked_Studies, geneListLabel)
}
\arguments{
\item{checked_Studies}{checked studies in corresponding panel (input$StudiesIDCircos, input$StudiesIDReactome).}

\item{geneListLabel}{The label of GeneList. There are three cases:
 "Genes" user gene list,
 "Reactome_GeneList" GeneList plus genes from reactomeFI
"file name" from Examples}
}
\value{
A LIST of profiles data (CNA, mRNA, Methylation, Mutation, miRNA, RPPA).
        Each dimension content a list of studies.
}
\description{
get list of data frame with profiles data (CNA,mRNA, Methylation, Mutation...)
}
\examples{
cgds <- cBioPortal(
hostname = "www.cbioportal.org",
protocol = "https",
api = "/api/v2/api-docs"
)
\dontrun{
getDataByGenes( api =  cgds,
studyId = "gbm_tcga_pub",
genes = c("NF1", "TP53", "ABL1"),
by = "hugoGeneSymbol",
molecularProfileIds = "gbm_tcga_pub_mrna"
)
}
}
