% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R
\docType{class}
\name{threshold_Results-class}
\alias{threshold_Results-class}
\alias{threshold_Results}
\title{threshold_Results object and constructor}
\usage{
threshold_Results(SummarizedExperiment, annotatedData)
}
\arguments{
\item{SummarizedExperiment}{a \code{RangedSummarizedExperiment} of
\code{threshold_Results} object.}

\item{annotatedData}{The annotated data passed as an input argument to
the \code{threshold_identification} function.}
}
\value{
a \code{\link[betaHMM:threshold_Results]{threshold_Results}} object
}
\description{
\code{threshold_Results} is a subclass of \code{RangedSummarizedExperiment},
used to store the threshold_identification results as well as the annotated
 data useful for plotting.
}
\details{
This constructor function would not typically be used by "end users".
This simple class extends the \code{RangedSummarizedExperiment} class of the
SummarizedExperiment package
to allow other packages to write methods for results
objects from the
\code{\link[betaHMM:threshold_identification]{threshold_identification}}
function. It is used by
to wrap up the results table.
}
\examples{
## Use simulated data for the betaHMM workflow example
set.seed(12345)
library(betaHMM)

## read files
data(sample_methylation_file)
head(sample_methylation_file)
data(sample_annotation_file)
head(sample_annotation_file)
##merge data
df=merge(sample_annotation_file[,c('IlmnID','CHR','MAPINFO')],
sample_methylation_file,by='IlmnID')

## sort data
df=df[order(df$CHR,df$MAPINFO),]
thr_out=threshold_identification(df[,c(1,4:7)],package_workflow=TRUE,M=3,4,
parameter_estimation_only=TRUE,seed=12345)

}
