% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Viterbi.R
\name{Viterbi}
\alias{Viterbi}
\title{Estimating the hidden states using Viterbi algorithm}
\usage{
Viterbi(data, M, N, R, tau, A, phi, K)
}
\arguments{
\item{data}{A dataframe of dimension \eqn{C \times (N \times R)} containing
methylation values for \eqn{C} CpG sites from \eqn{R}
treatment groups each having \eqn{N} replicates or each
collected from \eqn{N} patients.}

\item{M}{Number of methylation states to be identified
in a single DNA sample.}

\item{N}{Number of DNA samples (patients/replicates) collected for each
treatment group.}

\item{R}{Number of treatment groups (For. eg: Benign and Tumour).}

\item{tau}{The initial distribution for the betaHMM model.}

\item{A}{The transition matrix for the betaHMM model.}

\item{phi}{The shape parameters for the observation sequence data
in the betaHMM model.}

\item{K}{The number of hidden states identified using the betaHMM model.}
}
\value{
A vector containing the most probable sequence of the hidden states
of the betaHMM model.
}
\description{
The Viterbi algorithm is used to estimate the most probable
sequence of the hidden states utilizing the betaHMM model
parameters estimated by the Baum-Welch algorithm.
}
\keyword{internal}
