% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beadsRR.R
\name{beadsRR}
\alias{beadsRR}
\title{Beads-only round robin}
\usage{
beadsRR(object, method, BPPARAM = BiocParallel::bpparam(), ...)
}
\arguments{
\item{object}{PhIPData object}

\item{method}{one of \code{'beer'} or \code{'edgeR'} specifying which method
to use.}

\item{BPPARAM}{\code{[BiocParallel::BiocParallelParam]} passed to
BiocParallel functions.}

\item{...}{parameters passed to the method specific functions. See the
\emph{Details} section below for additional information.}
}
\value{
a PhIPData object
}
\description{
To approximate the false positive rate of each approach, each beads-only
sample is run individually against all other samples. For BEER, this means
that the sample to be compared is encoded as an actual sample, and prior
parameters for beads-only samples are re-estimated. Thus, the beads-only
round robin also serves to assess how similar the beads-only samples are to
one another.
}
\details{
If \strong{\code{method == 'beer'}}, then valid parameters include
\code{prior.params}, \code{beads.args}, \code{jags.params},
\code{sample.dir}, \code{assay.names}, and \code{summarize}. A description
of the first four parameters can be found in \code{\link{brew}}.
\code{summarize} is a logical value indicating whether a PhIPData object
with the summarized results should be returned. When running \code{beadsRR},
\code{summarize} typically does not need to be changed.

When \strong{\code{method == 'edgeR'}}, \code{threshold.cpm},
\code{threshold.prevalence}, and \code{assay.names} are valid additional
parameters that can be supplied to \code{beadsRR}. See \code{\link{edgeR}}
for additional details on each of these parameters.
}
\examples{
sim_data <- readRDS(system.file("extdata", "sim_data.rds", package = "beer"))

beadsRR(sim_data, method = "beer")
beadsRR(sim_data, method = "edgeR")
beadsRR(sim_data, method = "edgeR", de.method = "glmQLFTest")
}
\seealso{
\code{\link{brew}} for BEER parameters, \code{\link{edgeR}} for
edgeR parameters, and \code{[BiocParallel::BiocParallelParam]} for
parallelization.
}
