% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bayNorm.r
\name{bayNorm_sup}
\alias{bayNorm_sup}
\title{bayNorm with estimated parameters as input}
\usage{
bayNorm_sup(
  Data,
  PRIORS = NULL,
  input_params = NULL,
  mode_version = FALSE,
  mean_version = FALSE,
  S = 20,
  parallel = TRUE,
  NCores = 5,
  BB_SIZE = TRUE,
  verbose = TRUE,
  out.sparse = FALSE
)
}
\arguments{
\item{Data}{A matrix of single-cell expression where rows
are genes and columns are samples (cells). \code{Data}
can be of class \code{SummarizedExperiment} (the
assays slot contains the expression matrix,
is named "Counts"), just \code{matrix} or sparse matrix.}

\item{PRIORS}{A list of estimated prior parameters
obtained from bayNorm.}

\item{input_params}{A list of input parameters
which have been used: \code{BETA_vec}, \code{Conditions},
\code{UMI_sffl}, \code{Prior_type},
\code{FIX_MU}, \code{BB_SIZE} and \code{GR}.}

\item{mode_version}{If TRUE, bayNorm return mode
version normalized data which is of 2D matrix
instead of 3D array. Default is FALSE.}

\item{mean_version}{If TRUE, bayNorm return mean version
normalized data which is of 2D matrix instead of 3D array.
Default is FALSE.}

\item{S}{The number of samples you would like to
generate from estimated posterior distribution
(The third dimension of 3D array). Default is 20.
S needs to be specified if \code{mode_version}=FALSE.}

\item{parallel}{If TRUE, \code{NCores} cores will be
used for parallelization. Default is TRUE.}

\item{NCores}{number of cores to use, default is 5.
This will be used to set up a parallel environment
using either MulticoreParam (Linux, Mac) or
SnowParam (Windows) with NCores using the package
BiocParallel.}

\item{BB_SIZE}{If TRUE (default), use adjusted size for
normalization. The adjusted size is obtained by adjusting
MME estimated size by a factor. The factor is
calculated based on both MME estimated size and BB
estimated size. If FALSE, use MME estimated SIZE.}

\item{verbose}{print out status messages. Default is TRUE.}

\item{out.sparse}{Only valid for mean version: 
Whether the output is of type dgCMatrix or not. 
Default is FALSE.}
}
\value{
List containing 3D arrays of normalized
expression (if \code{mode_version}=FALSE) or 2D matrix
of normalized expression (if \code{mode_version}=TRUE
or \code{mean_version}=TRUE),
a list contains estimated priors and a list contains
input parameters used: \code{BETA_vec},
\code{Conditions} (if specified),
\code{UMI_sffl} (if specified), \code{Prior_type},
\code{FIX_MU}, \code{BB_SIZE} and \code{GR}.
}
\description{
This is a supplementary wrapper function
for bayNorm. It is useful if one has already estimated
prior parameters and wants to simulate 2D or 3D
normalized output using the same prior estimates.
}
\details{
If you have run bayNorm before and obtained a
list of estimated prior parameters, then you may not want
to run parameter estimation again. You can just use
previous estimated parameters for obtaining 3D or
2D normalized data.
}
\examples{
data('EXAMPLE_DATA_list')
#Return 3D array normalzied data:
bayNorm_3D<-bayNorm(
Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)],
BETA_vec = EXAMPLE_DATA_list$inputbeta[seq(1,30)]
,mode_version=FALSE,parallel =FALSE)

#Now if you want to generate 2D matrix using the same prior
#estimates as generated before:
bayNorm_2D<-bayNorm_sup(
Data=EXAMPLE_DATA_list$inputdata[,seq(1,30)]
,PRIORS=bayNorm_3D$PRIORS,
input_params = bayNorm_3D$input_params
,mode_version=TRUE)

}
\references{
Wenhao Tang, Francois Bertaux, Philipp Thomas,
Claire Stefanelli, Malika Saint, Samuel
Blaise Marguerat, Vahid Shahrezaei
bayNorm: Bayesian gene expression recovery,
imputation and normalisation for single cell RNA-sequencing data
Bioinformatics, btz726; doi: 10.1093/bioinformatics/btz726
}
