% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regressBatches.R
\name{regressBatches}
\alias{regressBatches}
\title{Regress out batch effects}
\usage{
regressBatches(
  ...,
  batch = NULL,
  design = NULL,
  keep = NULL,
  restrict = NULL,
  subset.row = NULL,
  correct.all = FALSE,
  d = NA,
  deferred = TRUE,
  assay.type = "logcounts",
  BSPARAM = IrlbaParam(),
  BPPARAM = SerialParam()
)
}
\arguments{
\item{...}{One or more log-expression matrices where genes correspond to rows and cells correspond to columns.
Alternatively, one or more \linkS4class{SingleCellExperiment} objects can be supplied containing a log-expression matrix in the \code{assay.type} assay.
Each object should contain the same number of rows, corresponding to the same genes in the same order.
Objects of different types can be mixed together.

If multiple objects are supplied, each object is assumed to contain all and only cells from a single batch.
If a single object is supplied, it is assumed to contain cells from all batches, so \code{batch} should also be specified.

Alternatively, one or more lists of matrices or SingleCellExperiments can be provided;
this is flattened as if the objects inside each list were passed directly to \code{...}.}

\item{batch}{A vector or factor specifying the batch of origin for all cells when only a single object is supplied in \code{...}.
This is ignored if multiple objects are present.}

\item{design}{A numeric design matrix with number of rows equal to the total number of cells,
specifying the experimental factors to remove.
Each row corresponds to a cell in the order supplied in \code{...}.}

\item{keep}{Integer vector specifying the coefficients of \code{design} to \emph{not} regress out,
see the \code{\link{ResidualMatrix}} constructor for more details.}

\item{restrict}{A list of length equal to the number of objects in \code{...}.
Each entry of the list corresponds to one batch and specifies the cells to use when computing the correction.}

\item{subset.row}{A vector specifying which features to use for correction.}

\item{correct.all}{Logical scalar indicating whether corrected expression values should be computed for genes not in \code{subset.row}.
Only relevant if \code{subset.row} is not \code{NULL}.}

\item{d}{Numeric scalar specifying the number of dimensions to use for PCA via \code{\link{multiBatchPCA}}.
If \code{NA}, no PCA is performed.}

\item{deferred}{Logical scalar indicating whether to defer centering/scaling, see \code{\link{multiBatchPCA}} for details.}

\item{assay.type}{A string or integer scalar specifying the assay containing the log-expression values.
Only used for SingleCellExperiment inputs.}

\item{BSPARAM}{A \linkS4class{BiocSingularParam} object specifying the algorithm to use for PCA in \code{\link{multiBatchPCA}}.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object specifying whether the PCA should be parallelized.}
}
\value{
A \linkS4class{SingleCellExperiment} object containing the \code{corrected} assay.
This contains the computed residuals for each gene (row) in each cell (column) in each batch.
A \code{batch} field is present in the column data, specifying the batch of origin for each cell.

Cells in the output object are always ordered in the same manner as supplied in \code{...}.
For a single input object, cells will be reported in the same order as they are arranged in that object.
In cases with multiple input objects, the cell identities are simply concatenated from successive objects,
i.e., all cells from the first object (in their provided order), then all cells from the second object, and so on.

If \code{d} is not \code{NA}, a PCA is performed on the residual matrix via \code{\link{multiBatchPCA}},
and an additional \code{corrected} field is present in the \code{\link{reducedDims}} of the output object.
}
\description{
Fit a linear model to each gene regress out uninteresting factors of variation, returning a matrix of residuals.
}
\details{
This function fits a linear model to the log-expression values for each gene and returns the residuals.
By default, the model is parameterized as a one-way layout with the batch of origin,
so the residuals represent the expression values after correcting for the batch effect.
The novelty of this function is that it returns a \linkS4class{ResidualMatrix} in as the \code{"corrected"} assay.
This avoids explicitly computing the residuals, which would result in a loss of sparsity or similar problems.
Rather, residuals are either computed as needed or are never explicitly computed at all (e.g., during matrix multiplication).
This means that \code{regressBatches} is faster and lighter than naive regression or even \code{\link{rescaleBatches}}.

More complex designs should be explicitly specified with the \code{design} argument, e.g., to regress out a covariate.
This can be any full-column-rank matrix that is typically constructed with \code{\link{model.matrix}}.
If \code{design} is specified with a single object in \code{...}, \code{batch} is ignored.
If \code{design} is specified with multiple objects, regression is applied to the matrix obtained by \code{cbind}ing all of those objects together; this means that the first few rows of \code{design} correspond to the cells from the first object, then the next rows correspond to the second object and so on.

Like \code{\link{rescaleBatches}}, this function assumes that the batch effect is orthogonal to the interesting factors of variation.
For example, each batch is assumed to have the same composition of cell types.
The same reasoning applies to any uninteresting factors specified in \code{design}, including continuous variables.
For example, if one were to use this function to regress out cell cycle, the assumption is that all cell types are similarly distributed across cell cycle phases.
If this is not true, the correction will not only be incomplete but can introduce spurious differences.

See \code{?"\link{batchelor-restrict}"} for a description of the \code{restrict} argument.
Specifically, this function will compute the model coefficients using only the specified subset of cells.
The regression will then be applied to all cells in each batch.

If set, the \code{d} option will perform a PCA via \code{\link{multiBatchPCA}}.
This is provided for convenience as efficiently executing a PCA on a \linkS4class{ResidualMatrix} is not always intuitive.
(Specifically, \linkS4class{BiocSingularParam} objects must be set up with \code{deferred=TRUE} for best performance.)
The arguments \code{BSPARAM}, \code{deferred} and \code{BPPARAM} only have an effect when \code{d} is set to a non-\code{NA} value.

All genes are used with the default setting of \code{subset.row=NULL}.
If a subset of genes is specified, residuals are only returned for that subset.
Similarly, if \code{d} is set, only the genes in the subset are used to perform the PCA.
If additionally \code{correct.all=TRUE}, residuals are returned for all genes but only the subset is used for the PCA.
}
\examples{
means <- 2^rgamma(1000, 2, 1)
A1 <- matrix(rpois(10000, lambda=means), ncol=50) # Batch 1 
A2 <- matrix(rpois(10000, lambda=means*runif(1000, 0, 2)), ncol=50) # Batch 2

B1 <- log2(A1 + 1)
B2 <- log2(A2 + 1)
out <- regressBatches(B1, B2) 

}
\seealso{
\code{\link{rescaleBatches}}, for another approach to regressing out the batch effect.

The \linkS4class{ResidualMatrix} class, for the class of the residual matrix.

\code{\link{applyMultiSCE}}, to apply this across multiple \code{\link{altExps}}.
}
\author{
Aaron Lun
}
