% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchNorm1.r
\name{peakInfo}
\alias{peakInfo}
\title{Extract m/z and rt from peak table}
\usage{
peakInfo(PT, sep = "_", timepos = 2, start = 1)
}
\arguments{
\item{PT}{a peak table with variables as columns}

\item{sep}{character separating mz from rt, e.g. "_"}

\item{timepos}{Which position carries info about rt 
(1 for before separator; 2 for after separator)}

\item{start}{character from which to start the read of 
peakInfo (from PT colnames)}
}
\value{
a matrix with m/z and rt of features as columns
}
\description{
Extract features from peak table and report their m/z and rt values
}
\examples{
data("ThreeBatchData")
# Extract peakinfo (i.e. m/z and rt of features). These column names have 2
# leading characters describing LC-MS mode -> start at 3
peakIn <- peakInfo(PT = PTnofill, sep = "@", start = 3)

}
