% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gets.R
\name{getBatch}
\alias{getBatch}
\title{Extract specific batch from peaktable and metadata}
\usage{
getBatch(peakTable, meta, batch, select)
}
\arguments{
\item{peakTable}{Multi-batch peak table}

\item{meta}{Multi-batch metadata (including e.g. batch, injection sequence, 
sample tye, sample name, ...)}

\item{batch}{vector (length = nSamples) containing batch information 
(e.g. A, B, C)}

\item{select}{which batch to extract}
}
\value{
list object

$peakTable: Single batch peak table

$meta: Single batch metadata
}
\description{
Extract specific batch from peaktable and metadata
}
\examples{
data("ThreeBatchData")
# Get batches for drift correction
batchB <- getBatch(
    peakTable = PTfill, meta = meta,
    batch = meta$batch, select = "B"
)
batchF <- getBatch(
    peakTable = PTfill, meta = meta,
    batch = meta$batch, select = "F"
)

}
