% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\docType{methods}
\name{summaryDemuxTable}
\alias{summaryDemuxTable}
\alias{summaryDemuxTable.basecallQC}
\alias{summaryDemuxTable,baseCallQC-method}
\alias{summaryDemuxTable,basecallQC-method}
\alias{summaryDemuxTable,list-method}
\title{Generate an HTML table of per sample summary demultiplexing statistics}
\usage{
\S4method{summaryDemuxTable}{baseCallQC}(object)

\S4method{summaryDemuxTable}{basecallQC}(object = "basecallQC",
  output = "static")

\S4method{summaryDemuxTable}{list}(object = "basecallQC", output = "static")
}
\arguments{
\item{object}{A  basecallQC object or list from call to demultiplexMetrics()}

\item{output}{Whether the report contains frozen or sortable tables. Options are "static" and "html"}
}
\value{
An HTML table for reporting demultiplexing results.
}
\description{
Generate an HTML table of per sample summary demultiplexing statistics
}
\examples{

fileLocations <- system.file("extdata",package="basecallQC")
runXML <- dir(fileLocations,pattern="runParameters.xml",full.names=TRUE)
config <- dir(fileLocations,pattern="config.ini",full.names=TRUE)
sampleSheet <- dir(fileLocations,pattern="*\\\\.csv",full.names=TRUE)
outDir <- file.path(fileLocations,"Runs/161105_D00467_0205_AC9L0AANXX/C9L0AANXX/")
bcl2fastqparams <- BCL2FastQparams(runXML,config,runDir=getwd(),outDir,verbose=FALSE)
bclQC <- basecallQC(bcl2fastqparams,RunMetaData=NULL,sampleSheet)
summaryDemuxTable(bclQC,output="static")
}
\author{
Thomas Carroll
}
