% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_banocc_output.R
\name{get_banocc_output}
\alias{get_banocc_output}
\title{Takes a model fit from BAnOCC, evaluates convergence and generates
  appropriate convergence metrics and inference}
\usage{
get_banocc_output(banoccfit, conf_alpha = 0.05, get_min_width = FALSE,
  calc_snc = TRUE, eval_convergence = TRUE, verbose = FALSE,
  num_level = 0)
}
\arguments{
\item{banoccfit}{Either a \code{stanfit} object (the \code{Fit} element
returned by \code{run_banocc}), or the list returned by a call to
\code{run_banocc}.}

\item{conf_alpha}{The percentage of the posterior density outside the
credible interval. That is, a \code{1-conf_alpha} * 100\% credible
interval will be returned.}

\item{get_min_width}{A boolean value: should the minimum CI width that
includes zero be calculated?}

\item{calc_snc}{Boolean: should the scaled neighborhood criterion be
calculated?}

\item{eval_convergence}{Boolean: if `TRUE`, convergence will be evaluated
using the Rhat statistic, and the fit output (estimates, credible
intervals, etc.) will be missing if this statistic does not indicate
convergence.}

\item{verbose}{Print informative statements as the function executes?}

\item{num_level}{The number of indentations to add to the output when
\code{verbose = TRUE}.}
}
\value{
Returns a named list with the following elements:
\describe{ 
  \item{\emph{CI}}{The \code{1-conf_alpha} * 100\% credible intervals}

  \item{\emph{Estimates.median}}{The correlation estimates, which are the
    marginal posterior medians}

  \item{\emph{Min.width}}{Only present if the \code{get_min_width}
    argument is \code{TRUE}. The minimum CI width that includes zero for
    each correlation.}

  \item{\emph{SNC}}{Only present if the \code{calc_snc} argument is
    \code{TRUE}. The scaled neighborhood criterion for each correlation.}

  \item{\emph{Fit}}{The \code{stanfit} object returned by the call to
    \code{run_banocc}.}

  \item{\emph{Data}}{Only present if the \code{banoccfit} argument is
    specified as the output of a call to \code{run_banocc}. It will be
    missing if \code{banoccfit} is specified as a \code{stanfit} object.}
}
}
\description{
Takes a model fit from BAnOCC, evaluates convergence and generates
  appropriate convergence metrics and inference
}
\examples{
data(compositions_null)
  \dontrun{
    compiled_banocc_model <- rstan::stan_model(model_code=banocc_model)
    b_fit <- run_banocc(C=compositions_null,
                            compiled_banocc_model=compiled_banocc_model)
    b_output <- get_banocc_output(banoccfit=b_fit)
  }

}
\seealso{
\code{vignette("banocc-vignette")} for more examples.
}

