% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-plots.R
\name{plotOutliers}
\alias{plotOutliers}
\title{Generate trace and density plots for all chains}
\usage{
plotOutliers(params, auto.layout = TRUE)
}
\arguments{
\item{params}{An instance of class \code{bandleParams}}

\item{auto.layout}{A \code{logical} specifying whether to automatically determine
the arrangement of each plot. Default is \code{TRUE}.}
}
\value{
Generates trace and density plots for each chain for each
condition/experiment.
}
\description{
This function takes the output from running \code{bandle} i.e. a \code{bandleParams}
object and generates trace and density plots for each MCMC chain in each
condition. The output plots can be used to help assess convergence of MCMC
chains.
}
\examples{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1,
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## fit GP params
gpParams <- lapply(tansim$lopitrep, function(x)
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))

## run bandle
res <- bandle(objectCond1 = control,
              objectCond2 = treatment,
              gpParams = gpParams,
              fcol = "markers",
              numIter = 20L,
              burnin = 1L,
              thin = 2L,
              numChains = 2,
              BPPARAM = SerialParam(RNGseed = 1),
              seed = 1)

## Process the results
plotOutliers(res)
}
