% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandle-plots.R
\name{spatial2D}
\alias{spatial2D}
\title{Generate a PCA plot with smoothed probability contours}
\usage{
spatial2D(
  object,
  params,
  fcol = "markers",
  dims = c(1, 2),
  cov.function = NULL,
  theta = 2,
  derivative = 2,
  k = 1,
  cond = 1,
  n = 1,
  breaks = c(0.99, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7),
  aspect = 0.5
)
}
\arguments{
\item{object}{An instance of class \code{MSnSet} to provide the pca coordinates}

\item{params}{An instance of class \code{bandleParams}}

\item{fcol}{Feature columns that defines the markers. Defaults to "markers".}

\item{dims}{The PCA dimensions to plot. Defaults to \code{c(1,2)}}

\item{cov.function}{The covariance function for the smoothing kernel.
Defaults to wendland.cov}

\item{theta}{The theta parameter of the wendland.cov. Defaults to 2.}

\item{derivative}{The derivative paramter of the wendland.cov. Defaults to
2.}

\item{k}{The k parameter of the wendland.cov}

\item{cond}{Which conditions do we want to plot. Must be \code{1} or \code{2}. Default
is \code{1}}

\item{n}{The chain from which we plot the probability distribution. Default
is 1.}

\item{breaks}{The levels at which to plot the contours. Defaults to c(0.99,
0.95, 0.9, 0.85, 0.8, 0.75, 0.7)}

\item{aspect}{The aspect ratio of the pca plots. Defaults to 0.5.}
}
\value{
returns a named vector of differential localisation probabilities
}
\description{
Generate a PCA plot with smoothed probability contours
}
\examples{
 \dontrun{
## Generate some example data
library("pRolocdata")
data("tan2009r1")
set.seed(1)
tansim <- sim_dynamic(object = tan2009r1, 
                      numRep = 4L,
                      numDyn = 100L)
data <- tansim$lopitrep
control <- data[1:2]
treatment <- data[3:4]

## fit GP params
gpParams <- lapply(tansim$lopitrep, function(x) 
fitGPmaternPC(x, hyppar = matrix(c(0.5, 1, 100), nrow = 1)))

## run bandle
res <- bandle(objectCond1 = control,
              objectCond2 = treatment, 
              gpParams = gpParams,
              fcol = "markers",  
              numIter = 5L, 
              burnin = 1L, 
              thin = 2L,
              numChains = 1, 
              BPPARAM = SerialParam(RNGseed = 1),
              seed = 1)
               
## Process the results
bandleres <- bandleProcess(res)

## plot the results
spatial2D(control[[1]], bandleres)
}
}
