% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gradientGP.R, R/likelihoodGP.R,
%   R/metropolisGP.R
\name{gradientGP}
\alias{gradientGP}
\alias{gradientGPmatern}
\alias{posteriorgradientGPmatern}
\alias{gradientlogprior}
\alias{likelihoodGP}
\alias{likelihoodGPmatern}
\alias{posteriorGPmatern}
\alias{Gumbel}
\alias{PCrhomvar}
\alias{metropolisGP}
\alias{metropolisGPmatern}
\title{Compute GP gradient}
\usage{
gradientGP(Xk, tau, h, nk, D)

gradientGPmatern(Xk, tau, h, nk, D, materncov, nu)

posteriorgradientGPmatern(Xk, tau, h, nk, D, materncov, nu, hyppar)

gradientlogprior(h, hyppar)

likelihoodGP(Xk, tau, h, nk, D)

likelihoodGPmatern(Xk, tau, h, nk, D, materncov, nu)

posteriorGPmatern(Xk, tau, h, nk, D, materncov, nu, hyppar)

Gumbel(x, lambda, log = TRUE)

PCrhomvar(rho, a, lambda1, lambda2, log = TRUE)

metropolisGP(
  inith,
  X,
  tau,
  nk,
  D,
  niter,
  hyperMean = c(0, 0, 0),
  hyperSd = c(1, 1, 1)
)

metropolisGPmatern(
  inith,
  X,
  tau,
  nk,
  D,
  niter,
  nu = 2,
  hyppar = c(1, 1, 1),
  propSd = c(0.3, 0.1, 0.1)
)

Gumbel(x, lambda, log = TRUE)

PCrhomvar(rho, a, lambda1, lambda2, log = TRUE)
}
\arguments{
\item{Xk}{The data}

\item{tau}{The indexing parameters}

\item{h}{GP hyperparameters}

\item{nk}{Number of observations}

\item{D}{number of samples}

\item{materncov}{\code{logical} indicating whether matern covariance is used}

\item{nu}{Smoothness of the matern covariance}

\item{hyppar}{A vector indicating the penalised complexity prior hyperparameters.
Default is \code{c(1,1,1)}}

\item{x}{observation}

\item{lambda}{scale parameter of the type-2 Gumbel distribution}

\item{log}{\code{logical} indicating whether to return \code{log}. Default is \code{TRUE}}

\item{rho}{length-scale parameter}

\item{a}{amplitude}

\item{lambda1}{first parameter of distribution}

\item{lambda2}{second parameter of distribution}

\item{inith}{initial hyperparamters}

\item{X}{The data}

\item{niter}{Number of MH iteractions}

\item{hyperMean}{A vector indicating the log-normal means. Default is \code{c(0,0,0)}.}

\item{hyperSd}{A vector indicating the log-normal standard deviations. Default is \code{c(1,1,1)}}

\item{propSd}{The proposal standard deviation. Default is \code{c(0.3,0.1,0.1)}. Do not
change unless you know what you are doing.}
}
\value{
Returns gp gradient

Returns gp gradient

Returns the gradient of the posterior

return the gradient of the log prior, length-scale, aamplitude and
noise

Returns gp negative log likelihood

Returns gp negative log likelihood

Returns the negative log posterior of the GP

Returns the likelihood of the type-2 GUmbel distribution

Returns the likelihood of the bivariate penalised complexity prior

Returns new hyperparamters and the acceptance rate

Returns the likelihood of the type-2 GUmbel distribution

Returns the likelihood of the bivariate penalised complexity prior
}
\description{
Internal R function to pass R to C++, not for external use.

Internal R function to pass R to C++, not for external use.

Function to perform Metropolis-Hastings for GP hyperparameters with different priors
}
\examples{
Gumbel(3, lambda = 1)

}
