% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/34_enrichment.R
\name{enrichment}
\alias{enrichment}
\title{Enrichment analysis}
\usage{
enrichment(
  object,
  pathwaydt,
  fit = fits(object)[1],
  coef = coefs(object, fit = fit)[1],
  var = abstractvar(object, fit = fit, coef = coef),
  levels = fdt(object)[[var]] \%>\% base::levels() \%>\% extract(-1),
  genevar = "gene",
  genesep = "[ ,;]",
  n = 3,
  verbose = TRUE,
  genes = FALSE
)
}
\arguments{
\item{object}{\code{SummarizedExperiment}}

\item{pathwaydt}{pathway \code{data.table}}

\item{fit}{string}

\item{coef}{string}

\item{var}{selection fvar}

\item{levels}{selection levels}

\item{genevar}{gene fvar}

\item{genesep}{gene separator (string)}

\item{n}{number}

\item{verbose}{whether to msg}

\item{genes}{whether to report genes}
}
\description{
Are selected genes enriched in pathway?
}
\details{
Four enrichment analyses per geneset using the Fisher Exact Test (see four pvalues).
Results are returned in a data.table
\tabular{rl}{
   in                \tab :                  genes      in pathway \cr
   in.det            \tab :         detected genes      in pathway \cr
   in.sel            \tab : up/downregulated genes      in pathway \cr
   in.up(.genes)     \tab :      upregulated genes      in pathway \cr
   in.down(.genes)   \tab :    downregulated genes      in pathway \cr
   out               \tab :                  genes outside pathway \cr
   det               \tab :         detected genes (in + out)      \cr
   sel               \tab : up/downregulated genes (in + out)      \cr
   up                \tab :      upregulated genes (in + out)      \cr
   down              \tab :    downregulated genes (in + out)      \cr
   p.coef.upDET      \tab : prob to randomly select this many (or more)   upregulated genes (among detected genes)       \cr
   p.coef.downDET    \tab : prob to randomly select this many (or more) downregulated genes (among detected genes)       \cr
   p.coef.selDET     \tab : prob to randomly select this many (or more) up OR downregulated genes (among detected genes) \cr
   p.coef.selGEN     \tab : prob to randomly select this many (or more) up OR downregulated genes (among genome   genes) \cr
   p.detGEN          \tab : prob to randomly select this many (or more) detected genes (among genome genes)
}
}
\examples{
# Read
    pathwaydt <- read_msigdt(collections = 'C5:GO:BP')
    file <- system.file('extdata/atkin.somascan.adat', package = 'autonomics')
    object <- read_somascan(file, fit = 'limma', coefs = 't1-t0')
    fvars(object) \%<>\% gsub('EntrezGeneSymbol', 'gene', .)
    object \%<>\% abstract_fit()
    varlevels <- c('flat', 'down', 'up')
    enrichdt1 <- enrichment(object, pathwaydt, var = 't1-t0~limma')                      # 2:n factor 
    enrichdt2 <- enrichment(object, pathwaydt, var = 't1-t0~limma', levels = varlevels)  # 1:n factor
    enrichdt3 <-  altenrich(object, pathwaydt)                 # alternative implementation
    cols <- intersect(names(enrichdt1), names(enrichdt3))
    all(enrichdt1[, cols, with = FALSE]  ==  enrichdt3[, cols, with = FALSE])   # identical
}
